<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);