<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vert Chasseur</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Titillium+Web:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Titillium Web', sans-serif;
        }
    </style>
</head>
<body>
    <header class="bg-white border-t border-b border-black">
        <div class="container mx-auto px-4 py-4">
            <div class="flex justify-between items-center">
                <div>
                    <a href="/" class="text-2xl font-bold">Vert Chasseur</a>
                    <p class="text-sm mt-1">Haven of joy - in Uccle, Brussels</p>
                </div>


                <nav class="hidden md:flex space-x-8">
                    <a href="/media" class="hover:text-gray-600">Actualité</a>
                    <a href="/shop" class="hover:text-gray-600">Commerce</a>
                    <a href="/weather" class="hover:text-gray-600">Météo</a>
                    <a href="https://imators.com/contact" class="hover:text-gray-600">Contact</a>
                </nav>


                <button id="menuBtn" class="md:hidden">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>


        <div id="mobileMenu" class="fixed inset-0 bg-white transform translate-x-full transition-transform duration-300 ease-in-out md:hidden">
            <div class="p-4">
                <button id="closeBtn" class="absolute top-4 right-4">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>


                <nav class="mt-16 text-left">
                    <ul class="space-y-6">
                        <li><a href="/media" class="block text-xl">Actualité</a></li>
                        <li><a href="/shop" class="block text-xl">Commerce</a></li>
                        <li><a href="/weather" class="block text-xl">Météo</a></li>
                        <li><a href="https://imators.com/contact-us" class="block text-xl">Contact</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>
    

    <script>
        const menuBtn = document.getElementById('menuBtn');
        const closeBtn = document.getElementById('closeBtn');
        const mobileMenu = document.getElementById('mobileMenu');

        menuBtn.addEventListener('click', () => {
            mobileMenu.classList.remove('translate-x-full');
        });

        closeBtn.addEventListener('click', () => {
            mobileMenu.classList.add('translate-x-full');
        });
    </script>
</body>
</html>