<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $document->title }} - Document partagé</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Urbanist', sans-serif; }
    </style>
</head>
<body class="bg-white text-black">
    <header class="border-b border-gray-200 bg-white">
        <div class="max-w-4xl mx-auto px-4 py-4">
            <div class="flex justify-between items-center">
                <h1 class="text-xl font-semibold">{{ $document->title }}</h1>
                <div class="text-sm text-gray-500">
                    {{ $permission === 'edit' ? 'Édition autorisée' : 'Lecture seule' }}
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-4xl mx-auto px-4 py-8">
        <div class="bg-white border border-gray-200 rounded-lg p-8">
            <div class="prose max-w-none">
                {!! $document->content !!}
            </div>
        </div>
    </main>
</body>
</html>