<?php
session_start();
require_once 'db.php';

$session_id = $_GET['session_id'] ?? '';

if (empty($session_id)) {
    die('Session invalide');
}

$stripe_config = require 'config/stripe.php';

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.stripe.com/v1/checkout/sessions/" . $session_id,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer " . $stripe_config['secret_key']
    ]
]);

$response = curl_exec($curl);
curl_close($curl);

$session = json_decode($response, true);

if (!$session || isset($session['error'])) {
    die('Erreur lors de la récupération de la session');
}

$resident_id = $session['client_reference_id'];
$subscription_id = $session['subscription'];
$customer_id = $session['customer'];

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.stripe.com/v1/subscriptions/" . $subscription_id,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer " . $stripe_config['secret_key']
    ]
]);

$response = curl_exec($curl);
curl_close($curl);

$subscription = json_decode($response, true);

$check_stmt = $conn->prepare("SELECT id FROM subscriptions WHERE stripe_subscription_id = ?");
$check_stmt->bind_param("s", $subscription_id);
$check_stmt->execute();
$existing = $check_stmt->get_result()->fetch_assoc();

if (!$existing) {
    $stmt = $conn->prepare("INSERT INTO subscriptions (resident_id, stripe_customer_id, stripe_subscription_id, stripe_price_id, status, current_period_start, current_period_end) VALUES (?, ?, ?, ?, ?, FROM_UNIXTIME(?), FROM_UNIXTIME(?))");
    $status = $subscription['status'];
    $stmt->bind_param("issssii", 
        $resident_id, 
        $customer_id, 
        $subscription_id, 
        $stripe_config['price_id'], 
        $status, 
        $subscription['current_period_start'], 
        $subscription['current_period_end']
    );
    $stmt->execute();
    $subscription_db_id = $conn->insert_id;

    if ($subscription['status'] === 'active') {
        $update_member = $conn->prepare("UPDATE residents SET member_ = 1 WHERE id = ?");
        $update_member->bind_param("i", $resident_id);
        $update_member->execute();
    }

    $latest_invoice = $subscription['latest_invoice'];
    if ($latest_invoice) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.stripe.com/v1/invoices/" . $latest_invoice,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer " . $stripe_config['secret_key']
            ]
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        $invoice = json_decode($response, true);

        if ($invoice) {
            $payment_stmt = $conn->prepare("INSERT INTO payment_history (resident_id, subscription_id, stripe_payment_intent_id, amount, currency, status, payment_date) VALUES (?, ?, ?, ?, ?, ?, NOW())");
            $amount = $invoice['amount_paid'] / 100;
            $currency = $invoice['currency'];
            $payment_status = $invoice['status'];
            $payment_intent_id = $invoice['payment_intent'];
            $payment_stmt->bind_param("iisdss", 
                $resident_id, 
                $subscription_db_id, 
                $payment_intent_id, 
                $amount, 
                $currency, 
                $payment_status
            );
            $payment_stmt->execute();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paiement réussi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }

        .checkmark {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: block;
            stroke-width: 3;
            stroke: #16a34a;
            stroke-miterlimit: 10;
            box-shadow: inset 0px 0px 0px #16a34a;
            animation: fill 0.4s ease-in-out 0.4s forwards, scale 0.3s ease-in-out 0.9s both;
        }

        .checkmark-circle {
            stroke-dasharray: 166;
            stroke-dashoffset: 166;
            stroke-width: 3;
            stroke-miterlimit: 10;
            stroke: #16a34a;
            fill: none;
            animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
        }

        .checkmark-check {
            transform-origin: 50% 50%;
            stroke-dasharray: 48;
            stroke-dashoffset: 48;
            animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
        }

        @keyframes stroke {
            100% {
                stroke-dashoffset: 0;
            }
        }

        @keyframes scale {
            0%, 100% {
                transform: none;
            }
            50% {
                transform: scale3d(1.1, 1.1, 1);
            }
        }

        @keyframes fill {
            100% {
                box-shadow: inset 0px 0px 0px 40px #16a34a;
            }
        }
    </style>
</head>

<body class="bg-gray-50 dark:bg-gray-900">
    <script>
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        }

        const translations = {
            fr: {
                title: "Paiement réussi !",
                subtitle: "Ton abonnement est maintenant actif",
                instruction: "Pour visualiser tes nouveaux privilèges, ferme cette page en appuyant sur la croix située en haut de l'écran, puis appuie sur le bouton \"Rafraîchir\" une fois de retour sur la page précédente.",
                invoice: "Une facture de confirmation a été envoyée à ton adresse e-mail.",
                support: "Si tu rencontres le moindre problème, n'hésite pas à contacter notre support."
            },
            en: {
                title: "Payment successful!",
                subtitle: "Your subscription is now active",
                instruction: "To view your new privileges, close this page by tapping the cross at the top of the screen, then tap the \"Refresh\" button once back on the previous page.",
                invoice: "A confirmation invoice has been sent to your email address.",
                support: "If you encounter any issues, feel free to contact our support team."
            }
        };

        const userLang = navigator.language || navigator.userLanguage;
        const lang = userLang.startsWith('fr') ? 'fr' : 'en';
        const t = translations[lang];

        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('title').textContent = t.title;
            document.getElementById('subtitle').textContent = t.subtitle;
            document.getElementById('instruction').textContent = t.instruction;
            document.getElementById('invoice').textContent = t.invoice;
            document.getElementById('support').textContent = t.support;
        });
    </script>

    <div class="min-h-screen flex items-center justify-center px-4">
        <div class="max-w-md w-full bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8 text-center">
            <div class="flex flex-col items-center">
                <svg class="checkmark mb-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
                    <circle class="checkmark-circle" cx="26" cy="26" r="25" fill="none"/>
                    <path class="checkmark-check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                </svg>
                <h2 id="title" class="text-2xl font-semibold text-gray-900 dark:text-white mb-2">
                    Paiement réussi !
                </h2>
                <p id="subtitle" class="text-lg font-medium text-green-600 dark:text-green-400 mb-4">
                    Ton abonnement est maintenant actif
                </p>
                <div class="w-full bg-gray-100 dark:bg-gray-700 rounded-lg p-4 mb-4">
                    <p id="instruction" class="text-sm text-gray-700 dark:text-gray-300 mb-3">
                        Pour visualiser tes nouveaux privilèges, ferme cette page en appuyant sur la croix située en haut de l'écran, puis appuie sur le bouton "Rafraîchir" une fois de retour sur la page précédente.
                    </p>
                    <p id="invoice" class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                        Une facture de confirmation a été envoyée à ton adresse e-mail.
                    </p>
                    <p id="support" class="text-xs text-gray-500 dark:text-gray-500">
                        Si tu rencontres le moindre problème, n'hésite pas à contacter notre support.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script>
        setTimeout(function() {
            if (window.ReactNativeWebView) {
                window.ReactNativeWebView.postMessage(JSON.stringify({
                    type: 'subscription_success',
                    success: true
                }));
            } else {
                window.close();
            }
        }, 2000);
    </script>
</body>
</html>