<?php
include 'db.php';
include 'header-mobile.php';

date_default_timezone_set('Europe/Brussels');

$today = date('Y-m-d');

$searchTerm = isset($_GET['search']) ? trim($_GET['search']) : '';

if (!empty($searchTerm)) {
    $searchQuery = mysqli_real_escape_string($conn, $searchTerm);
    $articles = mysqli_query($conn, "SELECT *, DATE_FORMAT(date_publication, '%d/%m/%Y') as formatted_date FROM articles WHERE status = 'published' AND (title LIKE '%$searchQuery%' OR content LIKE '%$searchQuery%' OR excerpt LIKE '%$searchQuery%') ORDER BY date_publication DESC");
} else {
    $articles = mysqli_query($conn, "SELECT *, DATE_FORMAT(date_publication, '%d/%m/%Y') as formatted_date FROM articles WHERE status = 'published' ORDER BY date_publication DESC");
}

$articlesToday = [];
$articlesRecent = [];
$articlesOld = [];

while ($article = mysqli_fetch_assoc($articles)) {
    $pubDate = date('Y-m-d', strtotime($article['date_publication']));
    $dateDiff = floor((strtotime($today) - strtotime($pubDate)) / (60 * 60 * 24));
    
    if ($pubDate == $today) {
        $articlesToday[] = $article;
    } elseif ($dateDiff <= 7) {
        $articlesRecent[] = $article;
    } else {
        $articlesOld[] = $article;
    }
}

function truncateText($text, $length = 150) {
    if (strlen($text) > $length) {
        $text = substr($text, 0, $length) . '...';
    }
    return $text;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualités - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <meta name="description" content="Suivez toutes les actualités et événements dans le quartier de Vert Chasseur à Uccle, Bruxelles.">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: { extend: {} }
        }
    </script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes scaleIn {
            from {
                opacity: 0;
                transform: scale(0.95);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }

        .animate-scale-in {
            animation: scaleIn 0.6s ease-out forwards;
            opacity: 0;
        }

        .card {
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
            cursor: pointer;
            opacity: 0;
            animation: fadeInUp 0.6s ease-out forwards;
        }

        .card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .dark .card:hover {
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5);
        }
        
        .cover-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
    </style>
</head>

<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
    </script>

    <main class="px-4 py-8 md:py-16 max-w-6xl mx-auto">
        <div class="flex flex-col items-center justify-center mb-8 md:mb-12 text-center relative">
            <h1 class="mt-4 md:mt-12 text-3xl md:text-5xl lg:text-6xl font-light text-stone-800 dark:text-white mb-2 md:mb-3 tracking-tight">
                Actualités
            </h1>
            <p class="text-lg md:text-xl text-stone-600 dark:text-stone-400 font-light">
                Découvrez les dernières nouvelles et événements de notre quartier.
            </p>
        </div>

        <div class="mb-16 animate-fade-in-up max-w-xl mx-auto" style="animation-delay: 0.3s">
            <form method="GET" action="media-mobile.php" class="relative">
                <input type="text" 
                       name="search"
                       value="<?= htmlspecialchars($searchTerm) ?>"
                       placeholder="Rechercher un article..." 
                       class="w-full px-7 py-4 rounded-2xl bg-white dark:bg-stone-900 shadow-sm dark:shadow-stone-900/30 border border-gray-200 dark:border-stone-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white transition-all duration-300">
                <button type="submit" class="absolute right-6 top-1/2 transform -translate-y-1/2">
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                </button>
            </form>
            
            <?php if (!empty($searchTerm)): ?>
            <div class="mt-4 text-center">
                <p class="text-gray-600 dark:text-gray-400 text-sm">
                    Résultats pour : <span class="font-semibold text-black dark:text-white">"<?= htmlspecialchars($searchTerm) ?>"</span>
                    <a href="media-mobile.php" class="ml-3 text-blue-500 hover:underline">Effacer</a>
                </p>
            </div>
            <?php endif; ?>
        </div>

        <?php if(!empty($articlesToday)): ?>
        <section class="mb-20">
            <div class="flex items-center gap-4 mb-10">
                <span class="text-xs font-bold uppercase tracking-widest text-gray-600 dark:text-gray-500">À la Une Aujourd'hui</span>
                <div class="h-px flex-1 bg-gradient-to-r from-gray-300 dark:from-gray-800 to-transparent"></div>
                <div class="px-3 py-1 bg-indigo-500 text-white text-xs font-medium rounded-full">Nouveau</div>
            </div>
            
            <div class="grid gap-7 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                <?php
                $delay = 0;
                foreach($articlesToday as $article):
                ?>
                <article class="card bg-white dark:bg-stone-900 rounded-3xl overflow-hidden border border-gray-100 dark:border-stone-800 shadow-xl dark:shadow-stone-900/40"
                         style="animation-delay: <?= $delay ?>s">
                    
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="bg-indigo-500 text-white text-xs font-medium px-3 py-1 rounded-full">
                                Aujourd'hui
                            </div>
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-xl font-semibold text-black dark:text-white mb-3"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-5"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content'])) ?></p>
                        
                        <div class="flex items-center justify-between mb-5">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                        </div>

                        <a href="/article-mobile.php?id=<?= $article['id'] ?>" class="group block w-full text-center py-3.5 rounded-xl transition-all duration-300 text-sm font-semibold relative overflow-hidden bg-black dark:bg-white text-white dark:text-black hover:shadow-xl hover:scale-105">
                            <span class="flex items-center justify-center gap-2">
                                Lire l'article
                                <i class="fas fa-arrow-right text-xs transform group-hover:translate-x-1 transition-transform duration-300"></i>
                            </span>
                        </a>
                    </div>
                </article>
                <?php $delay += 0.08; ?>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>

        <?php if(!empty($articlesRecent)): ?>
        <section class="mb-20">
            <div class="flex items-center gap-4 mb-10">
                <span class="text-xs font-bold uppercase tracking-widest text-gray-600 dark:text-gray-500">Articles Récents</span>
                <div class="h-px flex-1 bg-gradient-to-r from-gray-300 dark:from-gray-800 to-transparent"></div>
            </div>
            
            <div class="grid gap-7 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                <?php
                $delay = 0;
                foreach($articlesRecent as $article):
                ?>
                <article class="card bg-white dark:bg-stone-900 rounded-3xl overflow-hidden border border-gray-100 dark:border-stone-800 shadow-xl dark:shadow-stone-900/40"
                         style="animation-delay: <?= $delay ?>s">
                    
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="bg-blue-500 text-white text-xs font-medium px-3 py-1 rounded-full">
                                Récent
                            </div>
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-xl font-semibold text-black dark:text-white mb-3"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-5"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content'])) ?></p>
                        
                        <div class="flex items-center justify-between mb-5">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                        </div>

                        <a href="/article-mobile.php?id=<?= $article['id'] ?>" class="group block w-full text-center py-3.5 rounded-xl transition-all duration-300 text-sm font-semibold relative overflow-hidden bg-black dark:bg-white text-white dark:text-black hover:shadow-xl hover:scale-105">
                            <span class="flex items-center justify-center gap-2">
                                Lire l'article
                                <i class="fas fa-arrow-right text-xs transform group-hover:translate-x-1 transition-transform duration-300"></i>
                            </span>
                        </a>
                    </div>
                </article>
                <?php $delay += 0.08; ?>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>

        <?php if(!empty($articlesOld)): ?>
        <section class="mb-20">
            <div class="flex items-center gap-4 mb-10">
                <span class="text-xs font-bold uppercase tracking-widest text-gray-600 dark:text-gray-500">Archives</span>
                <div class="h-px flex-1 bg-gradient-to-r from-gray-300 dark:from-gray-800 to-transparent"></div>
            </div>
            
            <div class="grid gap-7 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                <?php
                $delay = 0;
                foreach($articlesOld as $article):
                ?>
                <article class="card bg-white dark:bg-stone-900 rounded-3xl overflow-hidden border border-gray-100 dark:border-stone-800 shadow-xl dark:shadow-stone-900/40"
                         style="animation-delay: <?= $delay ?>s">
                    
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-xl font-semibold text-black dark:text-white mb-3"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-5"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content']), 100) ?></p>
                        
                        <div class="flex items-center justify-between mb-5">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                        </div>

                        <a href="/article-mobile.php?id=<?= $article['id'] ?>" class="group block w-full text-center py-3.5 rounded-xl transition-all duration-300 text-sm font-semibold relative overflow-hidden bg-black dark:bg-white text-white dark:text-black hover:shadow-xl hover:scale-105">
                            <span class="flex items-center justify-center gap-2">
                                Lire l'article
                                <i class="fas fa-arrow-right text-xs transform group-hover:translate-x-1 transition-transform duration-300"></i>
                            </span>
                        </a>
                    </div>
                </article>
                <?php $delay += 0.08; ?>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>

        <?php if(empty($articlesToday) && empty($articlesRecent) && empty($articlesOld)): ?>
        <div class="text-center py-16">
            <div class="mb-6 text-gray-400 dark:text-gray-500">
                <i class="fas fa-newspaper text-5xl"></i>
            </div>
            <h3 class="text-xl font-medium text-black dark:text-white mb-2">Aucun article <?= !empty($searchTerm) ? 'trouvé' : 'pour le moment' ?></h3>
            <p class="text-gray-600 dark:text-gray-300">
                <?php if (!empty($searchTerm)): ?>
                    Essayez avec d'autres mots-clés.
                <?php else: ?>
                    Revenez bientôt pour découvrir les dernières actualités du quartier.
                <?php endif; ?>
            </p>
        </div>
        <?php endif; ?>
        
        <div class="text-center mt-12 animate-fade-in-up" style="animation-delay: 0.7s">
            <p class="text-gray-600 dark:text-gray-400 text-sm">
                Une actualité à partager ? 
                <a href="mailto:msg@aktascorp.com" class="text-black dark:text-white font-semibold hover:underline transition-all duration-300">
                    Contacte-nous !
                </a>
            </p>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.card').forEach(card => {
                card.addEventListener('click', function(e) {
                    const link = this.querySelector('a');
                    if (link && !e.target.closest('a')) {
                        window.location.href = link.href;
                    }
                });
            });
        });
    </script>
</body>
</html>