<?php
session_start();
header('Content-Type: application/json');

require_once 'vendor/autoload.php';
require_once 'db.php';

\Stripe\Stripe::setApiKey('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');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Méthode non autorisée']);
    exit;
}

if (!isset($_SESSION['resident_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Non authentifié']);
    exit;
}

$resident_id = $_SESSION['resident_id'];

try {
    $stmt = $conn->prepare("SELECT * FROM premium_subscriptions WHERE resident_id = ? AND status = 'active'");
    $stmt->bind_param("i", $resident_id);
    $stmt->execute();
    $subscription = $stmt->get_result()->fetch_assoc();
    
    if (!$subscription) {
        echo json_encode(['success' => false, 'error' => 'Aucun abonnement actif trouvé']);
        exit;
    }

    $stripe_subscription = \Stripe\Subscription::retrieve($subscription['stripe_subscription_id']);
    $stripe_subscription->cancel();

    $update_stmt = $conn->prepare("UPDATE premium_subscriptions SET status = 'canceled', canceled_at = NOW() WHERE id = ?");
    $update_stmt->bind_param("i", $subscription['id']);
    $update_stmt->execute();

    echo json_encode(['success' => true, 'message' => 'Abonnement annulé avec succès']);

} catch (\Stripe\Exception\InvalidRequestException $e) {
    echo json_encode(['success' => false, 'error' => 'Abonnement déjà annulé']);
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur Stripe']);
} catch (Exception $e) {
    error_log("Erreur annulation: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Erreur interne']);
}
?>