<?php
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

if (!function_exists('imators_track_init')) {
    function imators_track_init() {
        global $conn;
        
        if (!isset($conn) || $conn === null) {
            return;
        }

        if (!isset($_SESSION['imators_user_id'])) {
            if (isset($_COOKIE['imators_user_id'])) {
                $_SESSION['imators_user_id'] = $_COOKIE['imators_user_id'];
            } else {
                $_SESSION['imators_user_id'] = bin2hex(random_bytes(32));
                @setcookie('imators_user_id', $_SESSION['imators_user_id'], time() + (365 * 24 * 60 * 60), '/', '', false, true);
            }
        }

        $user_id = $_SESSION['imators_user_id'];
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $page_url = $_SERVER['REQUEST_URI'];
        $entry_time = date('Y-m-d H:i:s');

        $stmt = $conn->prepare("INSERT INTO `track-imators-systems-eps` (user_id, ip_address, page_url, entry_time) VALUES (?, ?, ?, ?)");
        if ($stmt) {
            $stmt->bind_param("ssss", $user_id, $ip_address, $page_url, $entry_time);
            $stmt->execute();
            $visit_id = $conn->insert_id;
            $stmt->close();

            $_SESSION['imators_visit_id'] = $visit_id;
            $_SESSION['imators_entry_time'] = time();
            
            echo '<script>
            const visitId = '.$visit_id.';
            const userId = "'.addslashes($user_id).'";
            const pageUrl = "'.addslashes($page_url).'";
            const entryTime = '.$_SESSION['imators_entry_time'].';

            document.addEventListener("click", function(e) {
                const elementType = e.target.tagName.toLowerCase();
                const elementText = e.target.innerText || e.target.textContent || "";
                const elementId = e.target.id || "";
                const elementClass = e.target.className || "";
                const clickX = e.clientX;
                const clickY = e.clientY;
                
                fetch("track_click.php", {
                    method: "POST",
                    headers: {"Content-Type": "application/json"},
                    body: JSON.stringify({
                        visit_id: visitId,
                        user_id: userId,
                        element_type: elementType,
                        element_text: elementText.substring(0, 500),
                        element_id: elementId,
                        element_class: elementClass,
                        click_x: clickX,
                        click_y: clickY,
                        page_url: pageUrl
                    })
                });
            });

            window.addEventListener("beforeunload", function() {
                const duration = Math.floor(Date.now() / 1000) - entryTime;
                navigator.sendBeacon("track_exit.php", JSON.stringify({
                    visit_id: visitId,
                    duration: duration
                }));
            });
            </script>';
        }
    }
    
    imators_track_init();
}
?>
