<?php
session_start();
include 'db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Méthode non autorisée']);
    exit;
}

if (!isset($_SESSION['resident_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Non authentifié']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['shop_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'shop_id manquant']);
    exit;
}

$shop_id = intval($data['shop_id']);
$resident_id = $_SESSION['resident_id'];

try {
    $stmt = $conn->prepare("INSERT INTO card_usage (resident_id, shop_id, used_at) VALUES (?, ?, NOW())");
    $stmt->bind_param("ii", $resident_id, $shop_id);
    
    if (!$stmt->execute()) {
        throw new Exception('Erreur insertion card_usage: ' . $stmt->error);
    }
    
    $update_stmt = $conn->prepare("UPDATE residents SET points = points + 5 WHERE id = ?");
    $update_stmt->bind_param("i", $resident_id);
    
    if (!$update_stmt->execute()) {
        throw new Exception('Erreur mise à jour points: ' . $update_stmt->error);
    }
    
    $points_stmt = $conn->prepare("SELECT points FROM residents WHERE id = ?");
    $points_stmt->bind_param("i", $resident_id);
    $points_stmt->execute();
    $result = $points_stmt->get_result();
    
    if ($result->num_rows === 0) {
        throw new Exception('Résident introuvable');
    }
    
    $points = $result->fetch_assoc()['points'];
    
    $tiers = [
        ['name' => 'Cool', 'min' => 0, 'max' => 100],
        ['name' => 'Great', 'min' => 100, 'max' => 500, 'reward' => '10€ offert'],
        ['name' => 'Crown', 'min' => 500, 'max' => 1000, 'reward' => 'Panier gourmand 40€'],
        ['name' => 'Gold', 'min' => 1000, 'max' => 5000],
        ['name' => 'Hunter', 'min' => 5000, 'max' => PHP_INT_MAX]
    ];
    
    foreach ($tiers as $tier) {
        if ($points >= $tier['min'] && $points < $tier['max']) {
            $check = $conn->prepare("SELECT id FROM rewards WHERE resident_id = ? AND tier = ? AND status = 'pending'");
            $check->bind_param("is", $resident_id, $tier['name']);
            $check->execute();
            
            if ($check->get_result()->num_rows === 0 && isset($tier['reward'])) {
                $reward_desc = $tier['reward'];
                $insert = $conn->prepare("INSERT INTO rewards (resident_id, tier, points_required, reward_description) VALUES (?, ?, ?, ?)");
                $insert->bind_param("isis", $resident_id, $tier['name'], $tier['min'], $reward_desc);
                $insert->execute();
            }
            break;
        }
    }
    
    http_response_code(200);
    echo json_encode([
        'success' => true, 
        'points' => $points,
        'shop_id' => $shop_id
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false, 
        'error' => $e->getMessage()
    ]);
}
?>
