<?php
require_once 'db.php';
session_start();

if ($_POST['action'] ?? '' === 'login') {
    header('Content-Type: application/json');
    $code = $_POST['code'];
    
    // Test direct sans password_verify pour debug
    $livreur = db()->fetchOne("SELECT * FROM vr_livreurs WHERE actif = 1 LIMIT 1");
    
    if ($livreur) {
        $_SESSION['livreur_id'] = $livreur['id'];
        $_SESSION['livreur_nom'] = $livreur['prenom'] . ' ' . $livreur['nom'];
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Aucun livreur trouvé']);
    }
    exit;
}

if ($_POST['action'] ?? '' === 'get_stats') {
    header('Content-Type: application/json');
    echo json_encode(['total_commandes' => 0, 'gains_total' => 0, 'note_moyenne' => 0, 'gains_semaine' => 0]);
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Test Livreur</title>
</head>
<body>
    <h1>Test Interface Livreur</h1>
    
    <?php if (!isset($_SESSION['livreur_id'])): ?>
    <form id="login">
        <input type="password" id="code" placeholder="Code">
        <button type="submit">Login</button>
    </form>
    <div id="result"></div>
    
    <script>
    document.getElementById('login').onsubmit = function(e) {
        e.preventDefault();
        fetch('test_livreur.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'action=login&code=' + document.getElementById('code').value
        })
        .then(r => r.text())
        .then(data => {
            document.getElementById('result').innerHTML = data;
            if (data.includes('success')) location.reload();
        });
    }
    </script>
    
    <?php else: ?>
    <p>Connecté comme: <?= $_SESSION['livreur_nom'] ?></p>
    <button onclick="location.href='test_livreur.php?logout=1'">Logout</button>
    <?php endif; ?>
</body>
</html>