<?php
include 'header.php';
include 'db.php';

date_default_timezone_set('Europe/Brussels');

$today = date('Y-m-d');

$articles = mysqli_query($conn, "SELECT *, DATE_FORMAT(date_publication, '%d/%m/%Y') as formatted_date FROM articles WHERE status = 'published' ORDER BY date_publication DESC");

$articlesToday = [];
$articlesRecent = [];
$articlesOld = [];

while ($article = mysqli_fetch_assoc($articles)) {
    $pubDate = date('Y-m-d', strtotime($article['date_publication']));
    $dateDiff = floor((strtotime($today) - strtotime($pubDate)) / (60 * 60 * 24));
    
    if ($pubDate == $today) {
        $articlesToday[] = $article;
    } elseif ($dateDiff <= 7) {
        $articlesRecent[] = $article;
    } else {
        $articlesOld[] = $article;
    }
}

function truncateText($text, $length = 150) {
    if (strlen($text) > $length) {
        $text = substr($text, 0, $length) . '...';
    }
    return $text;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualités - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <meta name="description" content="Suivez toutes les actualités et événements dans le quartier de Vert Chasseur à Uccle, Bruxelles.">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        dark: {
                            100: '#1e1e1e',
                            200: '#252525',
                            300: '#2d2d2d',
                            400: '#353535',
                            500: '#3a3a3a',
                        }
                    }
                }
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
        .article-card {
            transition: all 0.3s ease;
        }
        .article-card:hover {
            transform: translateY(-5px);
        }
        .article-today {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(99, 102, 241, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(99, 102, 241, 0); }
            100% { box-shadow: 0 0 0 0 rgba(99, 102, 241, 0); }
        }
        .cover-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
    </script>

    <main class="container mx-auto px-4 py-16 max-w-6xl">
        <header class="text-center mb-16 mt-20">
            <p class="text-gray-500 dark:text-gray-400 text-sm tracking-wider uppercase mb-3">Uccle · Bruxelles</p>
            <h1 class="text-4xl md:text-6xl font-light mb-5 text-black dark:text-white">
                <span class="txt-chasseur">Actualités</span> de Vert Chasseur
            </h1>
            <p class="text-lg text-gray-600 dark:text-gray-300 leading-relaxed max-w-2xl mx-auto">
                Découvrez les dernières nouvelles et événements de notre quartier
            </p>
        </header>

        <?php if(!empty($articlesToday)): ?>
        <div class="mb-16">
            <div class="flex items-center mb-8">
                <h2 class="text-2xl font-medium text-black dark:text-white">À la Une Aujourd'hui</h2>
                <div class="ml-4 px-3 py-1 bg-indigo-500 text-white text-xs font-medium rounded-full">Nouveau</div>
            </div>
            
            <div class="grid gap-8 grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
                <?php foreach($articlesToday as $article): ?>
                <article class="article-card article-today bg-white dark:bg-dark-200 rounded-2xl overflow-hidden border border-indigo-100 dark:border-indigo-900 shadow-lg">
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="bg-indigo-500 text-white text-xs font-medium px-3 py-1 rounded-full">
                                Aujourd'hui
                            </div>
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-xl font-medium text-black dark:text-white mb-3"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-5"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content'])) ?></p>
                        
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                            <a href="article.php?id=<?= $article['id'] ?>" class="group inline-flex items-center space-x-1 text-indigo-500 hover:text-indigo-600 text-sm font-medium">
                                <span>Lire la suite</span>
                                <i class="fas fa-arrow-right transform group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>
                </article>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php if(!empty($articlesRecent)): ?>
        <div class="mb-16">
            <h2 class="text-2xl font-medium text-black dark:text-white mb-8">Articles Récents</h2>
            
            <div class="grid gap-6 grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
                <?php foreach($articlesRecent as $article): ?>
                <article class="article-card bg-white dark:bg-dark-200 rounded-2xl overflow-hidden border border-gray-100 dark:border-gray-800 shadow-md">
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="bg-blue-500 text-white text-xs font-medium px-3 py-1 rounded-full">
                                Récent
                            </div>
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-xl font-medium text-black dark:text-white mb-3"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-5"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content'])) ?></p>
                        
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                            <a href="article.php?id=<?= $article['id'] ?>" class="group inline-flex items-center space-x-1 text-blue-500 hover:text-blue-600 text-sm font-medium">
                                <span>Lire la suite</span>
                                <i class="fas fa-arrow-right transform group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>
                </article>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php if(!empty($articlesOld)): ?>
        <div>
            <h2 class="text-2xl font-medium text-black dark:text-white mb-8">Archives</h2>
            
            <div class="grid gap-4 grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
                <?php foreach($articlesOld as $article): ?>
                <article class="article-card bg-white dark:bg-dark-200 rounded-lg overflow-hidden border border-gray-100 dark:border-gray-800">
                    <?php if (!empty($article['cover_image'])): ?>
                    <img src="<?= htmlspecialchars($article['cover_image']) ?>" alt="<?= htmlspecialchars($article['title']) ?>" class="cover-image rounded-t-[80px]">
                    <?php endif; ?>
                    
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?= $article['formatted_date'] ?></span>
                        </div>
                        
                        <h3 class="text-lg font-medium text-black dark:text-white mb-2"><?= htmlspecialchars($article['title']) ?></h3>
                        
                        <p class="text-gray-600 dark:text-gray-300 text-sm mb-3"><?= truncateText(htmlspecialchars($article['excerpt'] ?? $article['content']), 100) ?></p>
                        
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Par <?= htmlspecialchars($article['author']) ?></span>
                            <a href="article.php?id=<?= $article['id'] ?>" class="group inline-flex items-center text-gray-500 hover:text-gray-700 dark:hover:text-gray-300 text-sm">
                                <span>Lire</span>
                                <i class="fas fa-arrow-right ml-1 text-xs transform group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>
                </article>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php if(empty($articlesToday) && empty($articlesRecent) && empty($articlesOld)): ?>
        <div class="text-center py-16">
            <div class="mb-6 text-gray-400 dark:text-gray-500">
                <i class="fas fa-newspaper text-5xl"></i>
            </div>
            <h3 class="text-xl font-medium text-black dark:text-white mb-2">Aucun article pour le moment</h3>
            <p class="text-gray-600 dark:text-gray-300">
                Revenez bientôt pour découvrir les dernières actualités du quartier.
            </p>
        </div>
        <?php endif; ?>
    </main>

    <footer class="w-full py-8 mt-16 border-t border-gray-100 dark:border-gray-900">
        <p class="text-xs text-gray-500 dark:text-gray-400 text-center max-w-3xl mx-auto px-4">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-gray-600 dark:hover:text-gray-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-gray-600 dark:hover:text-gray-300">Confidentialité</a></p>
    </footer>
</body>
</html>