<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ini_set('session.gc_maxlifetime', 31536000);
ini_set('session.cookie_lifetime', 31536000);
session_set_cookie_params([
    'lifetime' => 31536000,
    'path' => '/',
    'domain' => $_SERVER['HTTP_HOST'],
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => true,
    'samesite' => 'Lax'
]);
session_start();

$logout_message = 'logout=1';
try {
    if (isset($_SESSION['resident_id'])) {
        include 'db.php';
        
        $resident_id = $_SESSION['resident_id'];
        
        if (isset($conn)) {
            $stmt = $conn->prepare("UPDATE residents SET last_logout = NOW(), remember_token = NULL WHERE id = ?");
            $stmt->bind_param("i", $resident_id);
            $stmt->execute();
        }
        
    } elseif (isset($_SESSION['guest_mode'])) {
        $logout_message = 'guest_logout=1';
    }
    
    $secure = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
    $domain = $_SERVER['HTTP_HOST'];
    
    setcookie('remember_token', '', time() - 3600, '/', $domain, $secure, true);
    setcookie('resident_email', '', time() - 3600, '/', $domain, $secure, false);
    
    $_SESSION = array();
    
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, 
                  $params["path"], 
                  $params["domain"], 
                  $params["secure"], 
                  $params["httponly"]);
    }
    
    session_destroy();
    
    header('Location: login.php?' . $logout_message, true, 302);
    exit();
    
} catch (Exception $e) {
    error_log("Erreur logout: " . $e->getMessage());
    
    $_SESSION = array();
    session_destroy();
    
    header('Location: login.php?error=logout_error', true, 302);
    exit();
}
?>