<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <link rel="icon" type="image/png" href="logo_new.png">
   <title>Vert Chasseur</title>    
   <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les commerces partenaire du quartier et les événements qui pourrait vous intéresser.">
   <script src="https://cdn.tailwindcss.com"></script>
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
   <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
   <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
   <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
   <meta name="color-scheme" content="light dark">
   <style>
       body {
           font-family: 'Poppins', sans-serif;
           letter-spacing: -0.01em;
           padding-bottom: 100px;
       }
       .card-hover {
           transition: transform 0.3s ease;
       }
       .card-hover:hover {
           transform: translateY(-4px);
       }
       .arrow-hover {
           transition: transform 0.3s ease;
       }
       .card-hover:hover .arrow-hover {
           transform: translateX(8px);
       }
       .txt-chasseur {
           font-family: "Princess Sofia", serif;
           font-weight: 400;
           font-style: normal;
       }
       .bottom-nav {
           background: rgba(255, 255, 255, 0.8);
           backdrop-filter: blur(20px) saturate(180%);
           -webkit-backdrop-filter: blur(20px) saturate(180%);
           border: 1px solid rgba(255, 255, 255, 0.3);
           box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
           position: relative;
           width: fit-content;
           max-width: 95vw;
           transition: transform 0.3s ease;
       }
       @media (prefers-color-scheme: dark) {
           .bottom-nav {
               background: rgba(0, 0, 0, 0.4);
               border: 1px solid rgba(255, 255, 255, 0.1);
               box-shadow: 0 8px 32px rgba(0, 0, 0, 0.5);
           }
       }
       .nav-item {
           transition: all 0.3s ease;
           position: relative;
           cursor: pointer;
           z-index: 2;
           padding: 14px;
       }
       .nav-item:active {
           transform: scale(0.95);
       }
       .nav-item svg {
           transition: all 0.3s ease;
           width: 26px;
           height: 26px;
       }
       .active-bubble {
           position: absolute;
           background: rgba(16, 185, 129, 0.15);
           width: 70px;
           height: 54px;
           border-radius: 27px;
           transition: all 0.4s ease;
           z-index: 1;
           top: 50%;
           transform: translateY(-50%);
           will-change: left;
       }
       @media (prefers-color-scheme: dark) {
           .active-bubble {
               background: rgba(16, 185, 129, 0.25);
           }
       }
       .nav-item.active svg {
           stroke: #10b981;
       }
       @keyframes slideIn {
           from {
               opacity: 0;
               transform: scale(0.9);
           }
           to {
               opacity: 1;
               transform: scale(1);
           }
       }
       .nav-item {
           animation: slideIn 0.5s ease-out backwards;
       }
       .nav-item:nth-child(1) { animation-delay: 0.1s; }
       .nav-item:nth-child(2) { animation-delay: 0.2s; }
       .nav-item:nth-child(3) { animation-delay: 0.3s; }
       .nav-item:nth-child(4) { animation-delay: 0.4s; }
       .nav-item:nth-child(5) { animation-delay: 0.5s; }
   </style>
   
</head>
<body>

  <nav class="bottom-nav fixed bottom-4 left-1/2 -translate-x-1/2 rounded-full z-40 px-6 py-3">
        <div class="flex justify-around items-center relative gap-3">
            <div class="active-bubble"></div>

            <a href="/media-mobile" class="nav-item flex items-center justify-center text-gray-600 dark:text-gray-400">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9.5a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                </svg>
            </a>
            
            <a href="/resident-dashboard" class="nav-item flex items-center justify-center text-gray-600 dark:text-gray-400">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
            </a>
            
            <a href="/shop-mobile" class="nav-item flex items-center justify-center text-gray-600 dark:text-gray-400">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                </svg>
            </a>
            
        </div>
    </nav>

<script>
function setActiveNavItem() {
   const currentPath = window.location.pathname;
   const navItems = document.querySelectorAll('.nav-item');
   const bubble = document.querySelector('.active-bubble');
   
   navItems.forEach((item, index) => {
       item.classList.remove('active');
       const href = item.getAttribute('href');
       if (href === currentPath || (currentPath === '/' && href === '/')) {
           item.classList.add('active');
           const itemRect = item.getBoundingClientRect();
           const containerRect = item.parentElement.getBoundingClientRect();
           const offsetLeft = itemRect.left - containerRect.left + (itemRect.width / 2) - 35;
           bubble.style.left = offsetLeft + 'px';
       }
   });
}

document.addEventListener('DOMContentLoaded', function() {
   setActiveNavItem();
});
</script>

</body>
</html>