<?php
session_start();
require_once 'db.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

// --- Autoloader maison pour PKPass ---
spl_autoload_register(function ($class) {
    $prefix = 'PKPass\\';
    $base_dir = __DIR__ . '/vendor/pkpass/pkpass/src/';

    if (strncmp($prefix, $class, strlen($prefix)) !== 0) {
        return;
    }

    $relative_class = substr($class, strlen($prefix));
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});
// -------------------------------------

$is_guest = false;
$resident = null;

if (!isset($_SESSION['resident_id']) && !isset($_SESSION['guest_mode'])) {
    header('Location: login.php');
    exit;
}
if (isset($_SESSION['guest_mode'])) {
    die('Fonction réservée aux résidents authentifiés.');
}

$resident_id = $_SESSION['resident_id'];
$stmt = $conn->prepare("SELECT last_name, first_name, address, email FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 0) {
    die('Aucun résident trouvé.');
}
$stmt->bind_result($last_name, $first_name, $address, $email);
$stmt->fetch();
$stmt->close();

// Définir le chemin des certificats et du logo
$certPath = __DIR__ . '/Certificat.p12';
$certPW = 'Izhak1122';
$logoPath = __DIR__ . '/logo_new.png';

// Créer un nouveau pass
$pass = new \PKPass\PKPass($certPath, $certPW);

$passJson = [
    "description" => "Pass Résident de la commune",
    "formatVersion" => 1,
    "organizationName" => "Commune d'Uccle",
    "serialNumber" => uniqid("res_", true),
    "backgroundColor" => "rgb(50,100,200)",
    "labelColor" => "rgb(255,255,255)",
    "foregroundColor" => "rgb(36,31,20)",
    "logoText" => "Résident Uccle",
    "generic" => [
        "primaryFields" => [[
            "key" => "name",
            "label" => "Nom",
            "value" => $first_name . " " . strtoupper($last_name)
        ]],
        "secondaryFields" => [[
            "key" => "email",
            "label" => "Email",
            "value" => $email
        ]],
        "auxiliaryFields" => [[
            "key" => "address",
            "label" => "Adresse",
            "value" => $address
        ]]
    ]
];

$pass->setData(json_encode($passJson));
$pass->addFile(__DIR__ . '/icon.png');
$pass->addFile(__DIR__ . '/logo_new.png');


$pass->create(true);
