<?php
require_once 'db.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'logout') {
    session_destroy();
    header('Location: config.php');
    exit;
}

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_password'])) {
        $adminPassword = 'VertChasseur2025!';
        if ($_POST['admin_password'] === $adminPassword) {
            $_SESSION['admin'] = true;
            header('Location: config.php');
            exit;
        } else {
            $error = 'Mot de passe incorrect';
        }
    }
    
    if (!isset($_SESSION['admin'])) {
        ?>
        <!DOCTYPE html>
        <html lang="fr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Configuration - Vert Chasseur</title>
            <style>
                body { font-family: Arial, sans-serif; background: #f5f5f5; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
                .login-container { background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); text-align: center; }
                .form-group { margin-bottom: 20px; text-align: left; }
                .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
                .form-group input { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 5px; font-size: 16px; }
                .btn { background: #2c5530; color: white; padding: 12px 30px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; width: 100%; }
                .error { color: red; margin-top: 10px; }
            </style>
        </head>
        <body>
            <div class="login-container">
                <h1>🌿 Configuration Vert Chasseur</h1>
                <form method="POST">
                    <div class="form-group">
                        <label>Mot de passe administrateur :</label>
                        <input type="password" name="admin_password" required>
                    </div>
                    <button type="submit" class="btn">Accéder</button>
                    <?php if (isset($error)): ?>
                        <div class="error"><?= $error ?></div>
                    <?php endif; ?>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'update_stripe':
            db()->setConfig('stripe_mode', $_POST['stripe_mode']);
            db()->setConfig('stripe_public_key_demo', $_POST['stripe_public_key_demo']);
            db()->setConfig('stripe_secret_key_demo', $_POST['stripe_secret_key_demo']);
            db()->setConfig('stripe_public_key_prod', $_POST['stripe_public_key_prod']);
            db()->setConfig('stripe_secret_key_prod', $_POST['stripe_secret_key_prod']);
            $success = 'Configuration Stripe mise à jour avec succès !';
            break;
            
        case 'update_onesignal':
            db()->setConfig('onesignal_app_id', $_POST['onesignal_app_id']);
            db()->setConfig('onesignal_api_key', $_POST['onesignal_api_key']);
            $success = 'Configuration OneSignal mise à jour avec succès !';
            break;
            
        case 'create_livreur':
            $code = bin2hex(random_bytes(8));
            $hashedCode = password_hash($code, PASSWORD_DEFAULT);
            
            try {
                $livreurId = db()->insert('vr_livreurs', [
                    'nom' => $_POST['nom'],
                    'prenom' => $_POST['prenom'],
                    'email' => $_POST['email'],
                    'telephone' => $_POST['telephone'],
                    'adresse' => $_POST['adresse'],
                    'latitude' => floatval($_POST['latitude']),
                    'longitude' => floatval($_POST['longitude']),
                    'code_acces' => $hashedCode
                ]);
                
                $jours = [1, 2, 3, 4, 5, 6, 0];
                foreach ($jours as $jour) {
                    if ($jour >= 1 && $jour <= 5) {
                        db()->insert('vr_disponibilites', [
                            'livreur_id' => $livreurId,
                            'jour_semaine' => $jour,
                            'heure_debut' => '12:40:00',
                            'heure_fin' => '13:40:00'
                        ]);
                        db()->insert('vr_disponibilites', [
                            'livreur_id' => $livreurId,
                            'jour_semaine' => $jour,
                            'heure_debut' => '15:20:00',
                            'heure_fin' => '17:30:00'
                        ]);
                    } else {
                        db()->insert('vr_disponibilites', [
                            'livreur_id' => $livreurId,
                            'jour_semaine' => $jour,
                            'heure_debut' => '14:20:00',
                            'heure_fin' => '18:30:00'
                        ]);
                    }
                }
                
                $success = "Livreur créé avec succès ! Code d'accès: <strong>$code</strong>";
            } catch (Exception $e) {
                $error = 'Erreur lors de la création: ' . $e->getMessage();
            }
            break;
            
        case 'create_commerce':
            try {
                db()->insert('vr_commerces', [
                    'nom' => $_POST['nom'],
                    'adresse' => $_POST['adresse'],
                    'latitude' => floatval($_POST['latitude']),
                    'longitude' => floatval($_POST['longitude']),
                    'telephone' => $_POST['telephone']
                ]);
                $success = 'Commerce créé avec succès !';
            } catch (Exception $e) {
                $error = 'Erreur lors de la création: ' . $e->getMessage();
            }
            break;
            
        case 'add_product':
            try {
                db()->insert('vr_produits', [
                    'commerce_id' => (int)$_POST['commerce_id'],
                    'nom' => $_POST['nom'],
                    'description' => $_POST['description'],
                    'prix' => floatval($_POST['prix'])
                ]);
                $success = 'Produit ajouté avec succès !';
            } catch (Exception $e) {
                $error = 'Erreur lors de l\'ajout: ' . $e->getMessage();
            }
            break;
            
        case 'test_notifications':
            $oneSignalAppId = db()->getConfig('onesignal_app_id');
            $oneSignalApiKey = db()->getConfig('onesignal_api_key');
            
            if ($oneSignalAppId && $oneSignalApiKey) {
                $notificationData = [
                    'app_id' => $oneSignalAppId,
                    'included_segments' => ['All'],
                    'headings' => ['fr' => 'Test Vert Chasseur'],
                    'contents' => ['fr' => 'Test de notification depuis le panel admin']
                ];
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://onesignal.com/api/v1/notifications');
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Basic ' . $oneSignalApiKey
                ]);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notificationData));
                
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                
                if ($httpCode === 200) {
                    $success = 'Notification test envoyée avec succès !';
                } else {
                    $error = 'Erreur envoi notification: ' . $response;
                }
            } else {
                $error = 'Configuration OneSignal manquante';
            }
            break;
    }
}

$config = [
    'stripe_mode' => db()->getConfig('stripe_mode') ?: 'demo',
    'stripe_public_key_demo' => db()->getConfig('stripe_public_key_demo') ?: '',
    'stripe_secret_key_demo' => db()->getConfig('stripe_secret_key_demo') ?: '',
    'stripe_public_key_prod' => db()->getConfig('stripe_public_key_prod') ?: '',
    'stripe_secret_key_prod' => db()->getConfig('stripe_secret_key_prod') ?: '',
    'onesignal_app_id' => db()->getConfig('onesignal_app_id') ?: '',
    'onesignal_api_key' => db()->getConfig('onesignal_api_key') ?: ''
];

$livreurs = db()->fetchAll("SELECT * FROM vr_livreurs ORDER BY prenom, nom") ?: [];
$commerces = db()->fetchAll("SELECT * FROM vr_commerces ORDER BY nom") ?: [];

try {
    $stats = db()->fetchOne("
        SELECT 
            COALESCE((SELECT COUNT(*) FROM vr_commandes WHERE statut = 'livree'), 0) as commandes_livrees,
            COALESCE((SELECT COUNT(*) FROM vr_commandes WHERE date_commande >= CURDATE()), 0) as commandes_aujourdhui,
            COALESCE((SELECT SUM(total_commande) FROM vr_commandes WHERE statut = 'livree'), 0) as ca_total,
            COALESCE((SELECT COUNT(*) FROM vr_livreurs WHERE actif = 1), 0) as livreurs_actifs
    ");
} catch (Exception $e) {
    $stats = [
        'commandes_livrees' => 0,
        'commandes_aujourdhui' => 0,
        'ca_total' => 0,
        'livreurs_actifs' => 0
    ];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuration - Vert Chasseur</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; }
        .header { background: #2c5530; color: white; padding: 15px 0; text-align: center; position: relative; }
        .logout-btn { position: absolute; right: 20px; top: 50%; transform: translateY(-50%); background: #dc3545; padding: 8px 15px; border: none; border-radius: 5px; color: white; cursor: pointer; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); text-align: center; }
        .stat-value { font-size: 24px; font-weight: bold; color: #2c5530; }
        .stat-label { color: #666; margin-top: 5px; }
        .section { background: white; padding: 25px; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .section h3 { color: #2c5530; margin-bottom: 20px; }
        .form-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group input, .form-group select, .form-group textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; }
        .btn { background: #2c5530; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
        .btn:hover { background: #1e3a21; }
        .btn-warning { background: #ffc107; color: #000; }
        .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin-bottom: 20px; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin-bottom: 20px; border: 1px solid #f5c6cb; }
        .table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        .table th, .table td { padding: 10px; border: 1px solid #ddd; text-align: left; }
        .table th { background: #f8f9fa; font-weight: bold; }
        .tabs { display: flex; border-bottom: 1px solid #ddd; margin-bottom: 20px; }
        .tab { padding: 10px 20px; background: none; border: none; cursor: pointer; border-bottom: 2px solid transparent; }
        .tab.active { border-bottom-color: #2c5530; color: #2c5530; font-weight: bold; }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        .commerce-card { border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; border-radius: 5px; background: #f9f9f9; }
        .product-form { display: grid; grid-template-columns: 2fr 3fr 1fr 1fr; gap: 10px; align-items: end; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>🌿 Vert Chasseur - Configuration</h1>
        <button class="logout-btn" onclick="logout()">Déconnexion</button>
    </div>

    <div class="container">
        <?php if (isset($success)): ?>
            <div class="success"><?= $success ?></div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
            <div class="error"><?= $error ?></div>
        <?php endif; ?>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-value"><?= $stats['commandes_livrees'] ?></div>
                <div class="stat-label">Commandes livrées</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $stats['commandes_aujourdhui'] ?></div>
                <div class="stat-label">Commandes aujourd'hui</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= number_format($stats['ca_total'], 0) ?>€</div>
                <div class="stat-label">CA total</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $stats['livreurs_actifs'] ?></div>
                <div class="stat-label">Livreurs actifs</div>
            </div>
        </div>

        <div class="section">
            <div class="tabs">
                <button class="tab active" onclick="showTab('stripe')">Stripe</button>
                <button class="tab" onclick="showTab('onesignal')">OneSignal</button>
                <button class="tab" onclick="showTab('livreurs')">Livreurs</button>
                <button class="tab" onclick="showTab('commerces')">Commerces</button>
            </div>

            <div class="tab-content active" id="stripe-tab">
                <h3>Configuration Stripe</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="update_stripe">
                    
                    <div class="form-group">
                        <label>Mode :</label>
                        <select name="stripe_mode">
                            <option value="demo" <?= $config['stripe_mode'] === 'demo' ? 'selected' : '' ?>>Démo/Test</option>
                            <option value="prod" <?= $config['stripe_mode'] === 'prod' ? 'selected' : '' ?>>Production</option>
                        </select>
                    </div>
                    
                    <div class="form-grid">
                        <div>
                            <h4>Clés de test</h4>
                            <div class="form-group">
                                <label>Clé publique test :</label>
                                <input type="text" name="stripe_public_key_demo" value="<?= htmlspecialchars($config['stripe_public_key_demo']) ?>" placeholder="pk_test_...">
                            </div>
                            <div class="form-group">
                                <label>Clé secrète test :</label>
                                <input type="password" name="stripe_secret_key_demo" value="<?= htmlspecialchars($config['stripe_secret_key_demo']) ?>" placeholder="sk_test_...">
                            </div>
                        </div>
                        
                        <div>
                            <h4>Clés de production</h4>
                            <div class="form-group">
                                <label>Clé publique prod :</label>
                                <input type="text" name="stripe_public_key_prod" value="<?= htmlspecialchars($config['stripe_public_key_prod']) ?>" placeholder="pk_live_...">
                            </div>
                            <div class="form-group">
                                <label>Clé secrète prod :</label>
                                <input type="password" name="stripe_secret_key_prod" value="<?= htmlspecialchars($config['stripe_secret_key_prod']) ?>" placeholder="sk_live_...">
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn">Sauvegarder Stripe</button>
                </form>
            </div>

            <div class="tab-content" id="onesignal-tab">
                <h3>Configuration OneSignal</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="update_onesignal">
                    
                    <div class="form-group">
                        <label>App ID :</label>
                        <input type="text" name="onesignal_app_id" value="<?= htmlspecialchars($config['onesignal_app_id']) ?>" placeholder="Votre App ID OneSignal">
                    </div>
                    
                    <div class="form-group">
                        <label>API Key :</label>
                        <input type="password" name="onesignal_api_key" value="<?= htmlspecialchars($config['onesignal_api_key']) ?>" placeholder="Votre REST API Key">
                    </div>
                    
                    <button type="submit" class="btn">Sauvegarder OneSignal</button>
                    <button type="submit" name="action" value="test_notifications" class="btn btn-warning">Test notification</button>
                </form>
            </div>

            <div class="tab-content" id="livreurs-tab">
                <h3>Gestion des livreurs</h3>
                
                <form method="POST" style="margin-bottom: 30px;">
                    <input type="hidden" name="action" value="create_livreur">
                    <h4>Nouveau livreur</h4>
                    
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Prénom :</label>
                            <input type="text" name="prenom" required>
                        </div>
                        <div class="form-group">
                            <label>Nom :</label>
                            <input type="text" name="nom" required>
                        </div>
                        <div class="form-group">
                            <label>Email :</label>
                            <input type="email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label>Téléphone :</label>
                            <input type="tel" name="telephone" required>
                        </div>
                        <div class="form-group">
                            <label>Adresse :</label>
                            <input type="text" name="adresse" required>
                        </div>
                        <div class="form-group">
                            <label>Latitude :</label>
                            <input type="number" step="0.000001" name="latitude" required placeholder="50.123456">
                        </div>
                        <div class="form-group">
                            <label>Longitude :</label>
                            <input type="number" step="0.000001" name="longitude" required placeholder="4.123456">
                        </div>
                    </div>
                    
                    <button type="submit" class="btn">Créer livreur</button>
                </form>

                <?php if (!empty($livreurs)): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nom</th>
                            <th>Email</th>
                            <th>Téléphone</th>
                            <th>Statut</th>
                            <th>Commandes</th>
                            <th>Note</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($livreurs as $livreur): ?>
                        <tr>
                            <td><?= $livreur['id'] ?></td>
                            <td><?= htmlspecialchars($livreur['prenom'] . ' ' . $livreur['nom']) ?></td>
                            <td><?= htmlspecialchars($livreur['email']) ?></td>
                            <td><?= htmlspecialchars($livreur['telephone']) ?></td>
                            <td><?= $livreur['actif'] ? 'Actif' : 'Inactif' ?></td>
                            <td><?= $livreur['nb_commandes'] ?></td>
                            <td><?= $livreur['note_moyenne'] ?: '-' ?>/5</td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php else: ?>
                <p>Aucun livreur créé pour le moment.</p>
                <?php endif; ?>
            </div>

            <div class="tab-content" id="commerces-tab">
                <h3>Gestion des commerces</h3>
                
                <form method="POST" style="margin-bottom: 30px;">
                    <input type="hidden" name="action" value="create_commerce">
                    <h4>Nouveau commerce</h4>
                    
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Nom :</label>
                            <input type="text" name="nom" required>
                        </div>
                        <div class="form-group">
                            <label>Téléphone :</label>
                            <input type="tel" name="telephone">
                        </div>
                        <div class="form-group">
                            <label>Adresse :</label>
                            <input type="text" name="adresse" required>
                        </div>
                        <div class="form-group">
                            <label>Latitude :</label>
                            <input type="number" step="0.000001" name="latitude" required placeholder="50.123456">
                        </div>
                        <div class="form-group">
                            <label>Longitude :</label>
                            <input type="number" step="0.000001" name="longitude" required placeholder="4.123456">
                        </div>
                    </div>
                    
                    <button type="submit" class="btn">Créer commerce</button>
                </form>

                <?php if (!empty($commerces)): ?>
                    <?php foreach ($commerces as $commerce): ?>
                    <div class="commerce-card">
                        <h4><?= htmlspecialchars($commerce['nom']) ?></h4>
                        <p><?= htmlspecialchars($commerce['adresse']) ?></p>
                        
                        <form method="POST">
                            <input type="hidden" name="action" value="add_product">
                            <input type="hidden" name="commerce_id" value="<?= $commerce['id'] ?>">
                            
                            <div class="product-form">
                                <input type="text" name="nom" placeholder="Nom produit" required>
                                <input type="text" name="description" placeholder="Description">
                                <input type="number" step="0.01" name="prix" placeholder="Prix €" required>
                                <button type="submit" class="btn">Ajouter</button>
                            </div>
                        </form>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                <p>Aucun commerce créé pour le moment.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
            
            event.target.classList.add('active');
            document.getElementById(tabName + '-tab').classList.add('active');
        }

        function logout() {
            if (confirm('Se déconnecter ?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = '<input type="hidden" name="action" value="logout">';
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>