<?php
session_start();
include '../db.php';

if (isset($_SESSION['merchant_id'])) {
    header('Location: dashboard.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $access_code = trim($_POST['access_code']);
    
    if (!empty($access_code)) {
        $stmt = $conn->prepare("SELECT * FROM merchant_profiles WHERE access_code = ? AND is_active = 1");
        $stmt->bind_param("s", $access_code);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($merchant = $result->fetch_assoc()) {
            $_SESSION['merchant_id'] = $merchant['id'];
            $_SESSION['shop_id'] = $merchant['shop_id'];
            $_SESSION['manager_name'] = $merchant['manager_name'];
            
            $update_stmt = $conn->prepare("UPDATE merchant_profiles SET last_login = NOW() WHERE id = ?");
            $update_stmt->bind_param("i", $merchant['id']);
            $update_stmt->execute();
            
            header('Location: dashboard.php');
            exit;
        } else {
            $error = 'Code d\'accès invalide ou compte désactivé.';
        }
    } else {
        $error = 'Veuillez entrer votre code d\'accès.';
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - Comm Access</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300 min-h-screen flex items-center justify-center p-4">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
    </script>

    <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <h1 class="text-4xl md:text-5xl font-light mb-3 tracking-tight">Comm Access</h1>
            <p class="text-lg text-gray-600 dark:text-gray-400 font-light">Tout sur Vert Chasseur</p>
        </div>

        <div class="bg-white dark:bg-stone-900 rounded-2xl p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30">
            <?php if ($error): ?>
            <div class="mb-6 p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
                <p class="text-red-800 dark:text-red-200 text-sm"><?= htmlspecialchars($error) ?></p>
            </div>
            <?php endif; ?>

            <form method="POST" class="space-y-6">
                <div>
                    <label for="access_code" class="block text-sm font-medium mb-2">Code d'accès</label>
                    <input 
                        type="text" 
                        id="access_code" 
                        name="access_code" 
                        required
                        autocomplete="off"
                        class="w-full px-4 py-3 bg-white dark:bg-black border border-stone-300 dark:border-stone-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 dark:focus:ring-green-600 transition-all"
                        placeholder="Entrez votre code">
                </div>

                <button 
                    type="submit"
                    class="w-full bg-green-600 hover:bg-green-700 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                    Se connecter
                </button>
            </form>

            <div class="mt-6 pt-6 border-t border-stone-200 dark:border-stone-800">
                <p class="text-sm text-gray-600 dark:text-gray-400 text-center">
                    Code perdu ? Contactez 
                    <a href="mailto:msg@aktascorp.com" class="text-green-600 dark:text-green-400 hover:underline">msg@aktascorp.com</a>
                </p>
            </div>
        </div>

        <div class="mt-8 text-center">
            <a href="/" class="text-sm text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200 transition-colors">
                ← Retour à Vert Chasseur
            </a>
        </div>
    </div>
</body>
</html>