<?php
include 'db.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$storeId = $input['storeId'];
$deliveryPersonId = $input['deliveryPersonId'];
$customerAddress = $input['customerAddress'];

$storeQuery = "SELECT latitude, longitude FROM stores WHERE id = ?";
$stmt = $conn->prepare($storeQuery);
$stmt->bind_param("i", $storeId);
$stmt->execute();
$store = $stmt->get_result()->fetch_assoc();

$livreurQuery = "SELECT latitude, longitude FROM livreur WHERE id = ?";
$stmt = $conn->prepare($livreurQuery);
$stmt->bind_param("i", $deliveryPersonId);
$stmt->execute();
$livreur = $stmt->get_result()->fetch_assoc();

if (!$store || !$livreur) {
    echo json_encode(['error' => 'Données introuvables']);
    exit;
}

function calculateDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371;
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat/2) * sin($dLat/2) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon/2) * sin($dLon/2);
    $c = 2 * atan2(sqrt($a), sqrt(1-$a));
    return $earthRadius * $c;
}

$customerLat = 50.8205;
$customerLng = 4.3605;

$livreurToStore = calculateDistance($livreur['latitude'], $livreur['longitude'], $store['latitude'], $store['longitude']);
$storeToCustomer = calculateDistance($store['latitude'], $store['longitude'], $customerLat, $customerLng);

$totalDistance = $livreurToStore + $storeToCustomer;
$deliveryFee = $totalDistance * 0.30;

echo json_encode([
    'deliveryFee' => round($deliveryFee, 2),
    'distance' => round($totalDistance, 1)
]);
?>