<?php
session_start();
include 'db.php';

$is_guest = false;
if (!isset($_SESSION['resident_id']) && !isset($_SESSION['guest_mode'])) {
    $_SESSION['guest_mode'] = true;
    $is_guest = true;
} elseif (isset($_SESSION['guest_mode'])) {
    $is_guest = true;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Politique de confidentialité - Vert Chasseur</title>
  <link rel="icon" type="image/png" href="logo_new.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
      tailwind.config = {
          darkMode: 'class',
          theme: {
              extend: {}
          }
      }
  </script>
  <script>
  if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
    document.documentElement.classList.add('dark');
} else {
    document.documentElement.classList.remove('dark');
}

window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
    if (!localStorage.theme) {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    }
});
  </script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
  <style>
    @media (min-width: 768px) {
        body {
            background-image: url('font-homepage.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            background-repeat: no-repeat;
        }
    }

    @media (max-width: 767px) {
        body {
            background-color: #ffffff !important;
            background-image: none !important;
        }
        .dark body {
            background-color: #000000 !important;
            background-image: none !important;
        }
    }

    body {
        font-family: 'Poppins', sans-serif;
        letter-spacing: -0.01em;
    }

    .txt-chasseur {
        font-family: "Princess Sofia", serif;
        font-weight: 400;
    }
  </style>
</head>

<body class="bg-white dark:bg-black transition-colors duration-300">
  <script>
      if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
          document.documentElement.classList.add('dark');
      } else {
          document.documentElement.classList.remove('dark');
      }
  </script>

<main class="min-h-screen px-4 py-8 md:py-16">
  <div class="max-w-3xl mx-auto">
    
    <div class="flex items-center gap-4 mb-8 md:mb-12">
      <a href="<?= $is_guest ? 'index.php' : 'resident-dashboard.php' ?>" class="p-2 text-stone-600 dark:text-stone-400 hover:text-stone-800 dark:hover:text-stone-200 transition-colors">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
      </a>
      <h1 class="text-3xl md:text-4xl font-light text-stone-800 dark:text-white tracking-tight">
        Politique de confidentialité
      </h1>
    </div>

    <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30 space-y-8">
      
      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Ta vie privée est importante</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Cette politique de confidentialité explique comment Vert Chasseur collecte, utilise et protège tes données personnelles. Nous croyons fermement que la transparence est le fondement d'une relation de confiance. Nous voulons que tu comprennes exactement ce que nous faisons de tes informations et comment nous les utilisons pour t'offrir une meilleure expérience.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Quelles données collectons-nous ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          Nous collectons les données que tu nous fournis directement et celles que nous recueillons automatiquement quand tu utilises Vert Chasseur.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les données que tu nous donnes :</strong> Lorsque tu crées un compte, tu nous fournis ton prénom, ton nom, ton adresse email et ton adresse. Si tu décides de t'abonner à la carte membre, nous collectons également les informations relatives à ton paiement. Tu peux aussi nous partager d'autres informations de manière optionnelle, comme tes préférences de communication ou tes habitudes de shopping.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les données que tu nous partages via la géolocalisation :</strong> Si tu autorises Vert Chasseur à accéder à ta localisation GPS, nous collectons tes coordonnées précises. Cela nous permet de te proposer des commerces à proximité et de vérifier quand tu es près d'un partenaire. Tu peux désactiver cette fonctionnalité à tout moment via les paramètres de ton téléphone ou de l'application.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les données de ton utilisation :</strong> Nous collectons automatiquement des informations sur comment tu utilises Vert Chasseur — quelles offres tu consultes, combien de temps tu passes sur chaque section, quels boutons tu cliques, quand tu accèdes à ta carte membre. Nous collectons également ton adresse IP, les pages que tu visites, la durée de tes sessions, les heures d'entrée et de sortie sur chaque page, ainsi que les éléments sur lesquels tu cliques (type d'élément, texte, position). Nous utilisons aussi des technologies comme les cookies et les pixels de suivi pour comprendre ton parcours dans l'application.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          <strong>Les informations techniques :</strong> Nous collectons des données sur ton appareil — le type de téléphone ou d'ordinateur que tu utilises, ton système d'exploitation, ton adresse IP, ton navigateur web. Ces données nous aident à maintenir la sécurité de l'application et à l'optimiser pour différents appareils.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Comment utilisons-nous tes données ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          Tes données nous permettent de te fournir les services de Vert Chasseur et de les améliorer constamment. Voici précisément ce que nous en faisons :
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour te fournir le service :</strong> Nous utilisons tes données pour créer et gérer ton compte, traiter tes paiements d'abonnement, afficher ta carte membre, et t'envoyer les notifications que tu as autorisées. Sans ces données, tu ne pourrais pas utiliser Vert Chasseur.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour personnaliser ton expérience :</strong> Nous analysons tes préférences, l'historique de tes visites, et tes habitudes de shopping pour te proposer des offres qui te correspondent vraiment. Si tu aimes les cafés, nous te montrerons les promotions des cafés partenaires. C'est du sur-mesure, pas du générique.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour t'aider à trouver ce que tu cherches :</strong> Grâce à ta localisation, nous pouvons te montrer quels commerces partenaires sont près de toi et tu peux facilement trouver les offres disponibles dans ton quartier. Ton adresse nous aide aussi à te proposer des services locaux pertinents.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour alimenter Comm Access et le réseau commercial :</strong> Tes données de localisation et de comportement d'achat aident à construire une base de données de la vitalité commerciale de Vert Chasseur. Cela permet aux commerces partenaires de mieux comprendre leur clientèle et d'adapter leurs offres. C'est bénéfique pour tout le monde — les commerces, toi, et la communauté.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour analyser les tendances et améliorer le service :</strong> Nous collectons et analysons des statistiques détaillées sur ton utilisation de Vert Chasseur : le nombre de visites, les pages consultées, le temps passé sur chaque page, les éléments sur lesquels tu cliques. Ces données nous aident à comprendre ce qui fonctionne bien et ce qui doit être amélioré. Elles nous permettent d'optimiser l'interface, de corriger les bugs, et de créer de nouvelles fonctionnalités adaptées à tes besoins.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour la promotion et le ciblage d'offres :</strong> Nous utilisons tes données pour promouvoir les produits et services qui seraient intéressants pour toi. Par exemple, si tu as consulté plusieurs offres de restaurants, nous pourrions te proposer une nouvelle promotion culinaire dès qu'elle arrive. C'est du marketing intelligent, pas du spam.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Pour améliorer et sécuriser Vert Chasseur :</strong> Nous analysons comment les gens utilisent l'application pour identifier les bugs, les problèmes de performance, et les domaines à améliorer. Nous testons aussi nos mesures de sécurité pour nous assurer que tes données sont protégées contre les menaces.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          <strong>Pour respecter nos obligations légales :</strong> Parfois, nous devons conserver et partager tes données si la loi nous l'exige — par exemple, en cas de fraude ou pour répondre à une demande légale d'une autorité.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Qui a accès à tes données ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          C'est simple : tes données restent au sein du groupe aktascorp et sont partagées uniquement avec les commerces partenaires de Vert Chasseur dans le cadre de la fourniture du service.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Notre équipe interne :</strong> Les membres du groupe aktascorp qui travaillent sur Vert Chasseur ont accès à tes données uniquement si c'est nécessaire pour t'aider ou améliorer le service. Nous limitons strictement ce accès et nous formons notre équipe aux pratiques de confidentialité.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les commerces partenaires :</strong> Lorsque tu utilises ta carte membre ou que tu consultes une offre, le commerce concerné peut avoir accès à certaines informations — juste ce qu'il faut pour traiter la transaction ou te proposer une meilleure offre. Par exemple, si tu utilises ta carte chez un restaurant, il sait que tu as acheté chez lui. C'est normal et nécessaire.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          <strong>Absolument personne d'autre :</strong> Nous ne partageons pas tes données avec des tiers externes au groupe aktascorp. Pas de plateformes publicitaires, pas de courtiers en données, pas d'entreprises de marketing. Tes données ne quittent pas notre écosystème local. C'est une promesse claire et sans ambiguïté.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Comment protégeons-nous tes données ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          La sécurité est une priorité absolue. Nous utilisons plusieurs couches de protection pour garder tes données en sécurité.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Chiffrement :</strong> Toutes les données sensibles que tu nous envoies — comme tes identifiants ou tes informations de paiement — sont chiffrées en transit et au repos. Cela signifie que même si quelqu'un intercepte la transmission, il ne peut pas lire tes données.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Contrôle d'accès :</strong> Seules les personnes autorisées au sein du groupe aktascorp peuvent accéder à tes données, et uniquement si c'est nécessaire pour accomplir leur travail. Chaque accès est enregistré et surveillé.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Bases de données sécurisées :</strong> Tes données sont stockées sur des serveurs sécurisés avec des pare-feu, des systèmes de détection d'intrusion, et des sauvegardes régulières pour éviter la perte de données.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          <strong>Audits et tests de sécurité :</strong> Nous effectuons régulièrement des audits de sécurité et des tests de pénétration pour identifier et corriger les vulnérabilités avant qu'elles ne deviennent un problème.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Pendant combien de temps conservons-nous tes données ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          Nous conservons tes données aussi longtemps que tu as besoin d'utiliser Vert Chasseur. Si tu supprimes ton compte, nous supprimons tes données personnelles dans un délai de 30 jours, sauf si nous devons les conserver pour des raisons légales.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Les données d'utilisation et les historiques de transactions peuvent être conservés plus longtemps pour des raisons de conformité légale ou d'amélioration du service, mais elles sont anonymisées et ne peuvent pas t'être associées directement.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Tes droits sur tes données</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          Conformément au Règlement Général sur la Protection des Données (RGPD), tu as plusieurs droits concernant tes données :
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Droit d'accès :</strong> Tu peux demander une copie de toutes les données personnelles que nous conservons à ton sujet. Nous te les fournirons dans un format lisible et compréhensible.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Droit de rectification :</strong> Si tes données sont incorrectes ou incomplètes, tu peux nous demander de les corriger. Par exemple, si tu as changé d'adresse, tu peux la mettre à jour dans tes paramètres.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Droit à l'effacement :</strong> Tu peux nous demander de supprimer tes données personnelles. Nous ferons de notre mieux, sauf si nous sommes obligés de les conserver pour des raisons légales.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Droit à la portabilité :</strong> Tu peux demander tes données dans un format machine-lisible pour les transférer ailleurs.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Droit d'opposition :</strong> Tu peux t'opposer à certains traitements de tes données, par exemple le ciblage d'offres ou l'analyse de comportement.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Pour exercer ces droits, contacte-nous à l'adresse : <span class="font-semibold text-stone-800 dark:text-white">msg@aktascorp.com</span>. Nous traiterons ta demande dans les 30 jours.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Cookies et technologies de suivi</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-4">
          Vert Chasseur utilise des cookies et autres technologies de suivi pour améliorer ton expérience. Voici ce que tu dois savoir :
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les cookies essentiels :</strong> Ces cookies sont nécessaires au fonctionnement de l'application. Ils gardent te connecté, sauvegardent tes préférences et assurent la sécurité. Sans eux, l'app ne fonctionnerait pas.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les cookies d'identification :</strong> Nous utilisons un cookie unique pour identifier ton appareil et suivre tes visites sur le site. Ce cookie a une durée de validité d'un an et nous permet de reconnaître si tu es un visiteur récurrent ou nouveau, de compter le nombre de visites uniques, et d'analyser ton comportement de navigation.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">
          <strong>Les cookies analytiques :</strong> Nous utilisons des outils pour comprendre comment tu utilises Vert Chasseur. Ces données nous aident à améliorer l'interface et la performance.
        </p>

        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Tu peux contrôler les cookies via les paramètres de ton navigateur ou de ton téléphone. Tu peux même les désactiver, mais sois conscient que cela peut affecter ton expérience utilisateur.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Modifications de cette politique</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Nous pouvons mettre à jour cette politique de confidentialité de temps à autre. Lorsque nous le ferons, nous te notifierons via l'application ou par email. Nous te demandons de la consulter régulièrement pour rester informé. Ton utilisation continue de Vert Chasseur après une modification constitue ton acceptation de la nouvelle politique.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Des questions ?</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Si tu as des questions sur cette politique de confidentialité, si tu souhaites exercer tes droits, ou si tu as des préoccupations concernant notre traitement de tes données, contacte-nous. Nous sommes ici pour t'aider et pour écouter tes retours. Adresse-toi à : <span class="font-semibold text-stone-800 dark:text-white">msg@aktascorp.com</span>
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">Responsable de la protection des données</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Pour toute question relative à la protection des données chez Vert Chasseur, tu peux aussi contacter directement : <span class="font-semibold text-stone-800 dark:text-white">privacy@aktascorp.com</span>
        </p>
      </section>

      <div class="pt-6 border-t border-stone-200 dark:border-stone-700">
        <p class="text-sm text-stone-500 dark:text-stone-400 text-center">
          Dernière mise à jour : 25 novembre 2025
        </p>
      </div>

    </div>

  </div>
</main>

</body>
</html>
