<?php
session_start();
$adminMode = isset($_GET['admin']) && $_GET['admin'] === 'true';

$blips = [
    [
        'id' => 1,
        'name' => 'Delitraiteur',
        'lat' => 50.80059172017383,
        'lng' => 4.373969435691834,
        'type' => 'store',
        'icon' => 'fa-store',
        'url' => 'https://delitraiteur.com/wp-content/uploads/2024/03/cropped-delitraiteur-logo.png'
    ],
    [
        'id' => 2,
        'name' => 'Carrefour Express',
        'lat' => 50.80147830828062,
        'lng' => 4.373231828212739,
        'type' => 'store',
        'icon' => 'fa-store',
        'url' => null
    ],
    [
        'id' => 3,
        'name' => 'La Villa Lorraine Traiteur',
        'lat' => 50.80179869640314,
        'lng' => 4.3730413913726816,
        'type' => 'catering',
        'icon' => 'fa-store',
        'url' => 'https://starwinelist.com/storage/images/venue/2282/300/3XZfu04sKSDbZNRlbBcdPqXLLfJPIsn4CJ69yytl.png?signature=c7aa9bd35a441bd2a062dbfc858f5a7212cafd0507fa6e1c7f09943c48b6c4dd'
    ],
    [
        'id' => 4,
        'name' => 'La Villa Lorraine',
        'lat' => 50.79951016161863,
        'lng' => 4.3784862756729135,
        'type' => 'restaurant',
        'icon' => 'fa-utensils',
        'url' => 'https://starwinelist.com/storage/images/venue/2282/300/3XZfu04sKSDbZNRlbBcdPqXLLfJPIsn4CJ69yytl.png?signature=c7aa9bd35a441bd2a062dbfc858f5a7212cafd0507fa6e1c7f09943c48b6c4dd'
    ]
];

$zoneData = [
    'center' => ['lat' => 50.800740898699665, 'lng' => 4.370884895324708, 'zoom' => 16],
    'zone' => [
        ['lat' => 50.80547367922133, 'lng' => 4.376249313354493],
        ['lat' => 50.801961432385966, 'lng' => 4.377751350402833],
        ['lat' => 50.79931690243816, 'lng' => 4.378888607025147],
        ['lat' => 50.796712911337075, 'lng' => 4.379446506500245],
        ['lat' => 50.79622464685215, 'lng' => 4.374210834503175],
        ['lat' => 50.79600763877701, 'lng' => 4.367022514343263],
        ['lat' => 50.797282546788885, 'lng' => 4.366786479949952],
        ['lat' => 50.79747242372991, 'lng' => 4.365756511688233],
        ['lat' => 50.79846248385208, 'lng' => 4.364705085754395],
        ['lat' => 50.79934402658185, 'lng' => 4.363932609558106],
        ['lat' => 50.801134185257695, 'lng' => 4.362559318542481],
        ['lat' => 50.80212416780201, 'lng' => 4.362301826477052],
        ['lat' => 50.80304632445409, 'lng' => 4.362366199493409],
        ['lat' => 50.80373792999973, 'lng' => 4.3625807762146005],
        ['lat' => 50.80455157047645, 'lng' => 4.367430210113526],
        ['lat' => 50.80506686878319, 'lng' => 4.370605945587159],
        ['lat' => 50.80532451580529, 'lng' => 4.372129440307618],
        ['lat' => 50.80546011893046, 'lng' => 4.373846054077149]
    ]
];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zone Access</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
            width: 100%;
            font-family: 'Inter', sans-serif;
        }

        #map {
            height: 100%;
            width: 100%;
        }

        .leaflet-container {
            font-family: 'Inter', sans-serif;
            background: #f8f9fa;
        }

        @media (prefers-color-scheme: dark) {
            .leaflet-container {
                background: #0f0f0f;
            }

            .leaflet-tile {
                filter: invert(0.93) hue-rotate(180deg) brightness(1.05) contrast(0.9);
            }
        }

        .location-dot {
            width: 20px;
            height: 20px;
            background-color: #0ea5e9;
            border-radius: 50%;
            border: 3px solid white;
            box-shadow: 0 0 0 2px rgba(14, 165, 233, 0.3);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(14, 165, 233, 0.7); }
            70% { box-shadow: 0 0 0 15px rgba(14, 165, 233, 0); }
            100% { box-shadow: 0 0 0 0 rgba(14, 165, 233, 0); }
        }

        .blip-icon {
            width: 44px;
            height: 44px;
            background: white;
            border: 2px solid #0ea5e9;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: #0ea5e9;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.12);
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .blip-icon:hover {
            transform: scale(1.15);
            box-shadow: 0 4px 16px rgba(14, 165, 233, 0.4);
        }

        @media (prefers-color-scheme: dark) {
            .blip-icon {
                background: #1a1a1a;
                border-color: #0ea5e9;
            }
        }

        .leaflet-popup-content-wrapper {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
            border: none;
            color: black;
        }

        @media (prefers-color-scheme: dark) {
            .leaflet-popup-content-wrapper {
                background: #1a1a1a;
                color: white;
            }
        }

        .leaflet-control-container {
            display: none;
        }

        .leaflet-pane {
            z-index: auto !important;
        }

        .search-wrapper {
            position: fixed;
            top: 24px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1000;
            width: 100%;
            max-width: 420px;
            padding: 0 20px;
        }

        .search-bar {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(30px);
            -webkit-backdrop-filter: blur(30px);
            border-radius: 20px;
            box-shadow: 0 8px 40px rgba(0, 0, 0, 0.08);
            padding: 14px 22px;
            border: 1px solid rgba(255, 255, 255, 0.6);
            display: flex;
            align-items: center;
            gap: 12px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .search-bar:focus-within {
            background: rgba(255, 255, 255, 0.85);
            box-shadow: 0 16px 48px rgba(14, 165, 233, 0.15);
            border-color: rgba(14, 165, 233, 0.3);
        }

        @media (prefers-color-scheme: dark) {
            .search-bar {
                background: rgba(255, 255, 255, 0.08);
                border-color: rgba(255, 255, 255, 0.15);
            }

            .search-bar:focus-within {
                background: rgba(255, 255, 255, 0.12);
                border-color: rgba(255, 255, 255, 0.2);
            }
        }

        .search-bar i {
            color: #0ea5e9;
            font-size: 16px;
        }

        .search-bar input {
            flex: 1;
            border: none;
            background: transparent;
            outline: none;
            font-size: 14px;
            color: #000;
            font-weight: 500;
        }

        @media (prefers-color-scheme: dark) {
            .search-bar input {
                color: #fff;
            }
        }

        .search-bar input::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        @media (prefers-color-scheme: dark) {
            .search-bar input::placeholder {
                color: rgba(255, 255, 255, 0.5);
            }
        }

        .search-results {
            position: absolute;
            top: calc(100% + 12px);
            left: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.75);
            backdrop-filter: blur(30px);
            -webkit-backdrop-filter: blur(30px);
            border-radius: 20px;
            box-shadow: 0 16px 48px rgba(0, 0, 0, 0.12);
            border: 1px solid rgba(255, 255, 255, 0.6);
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (prefers-color-scheme: dark) {
            .search-results {
                background: rgba(255, 255, 255, 0.08);
                border-color: rgba(255, 255, 255, 0.15);
            }
        }

        .search-results.active {
            max-height: 400px;
            opacity: 1;
            overflow-y: auto;
        }

        .search-result-item {
            padding: 14px 22px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.08);
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 12px;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .search-result-item {
                border-bottom-color: rgba(255, 255, 255, 0.1);
                color: #fff;
            }
        }

        .search-result-item:hover {
            background: rgba(14, 165, 233, 0.1);
        }

        .search-result-item:last-child {
            border-bottom: none;
        }

        .search-result-content {
            flex: 1;
        }

        .search-result-name {
            font-weight: 600;
            font-size: 14px;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .search-result-name {
                color: #fff;
            }
        }

        .search-result-type {
            font-size: 12px;
            opacity: 0.6;
            margin-top: 4px;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .search-result-type {
                color: rgba(255, 255, 255, 0.7);
            }
        }

        .search-result-action {
            background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
            color: white;
            border: none;
            border-radius: 10px;
            padding: 8px 14px;
            font-size: 12px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            white-space: nowrap;
            box-shadow: 0 2px 8px rgba(14, 165, 233, 0.2);
        }

        .search-result-action:hover:not(:disabled) {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.3);
        }

        .search-result-action:disabled {
            background: #ccc;
            cursor: not-allowed;
            box-shadow: none;
            opacity: 0.6;
        }

        .admin-panel {
            position: fixed;
            bottom: 24px;
            right: 24px;
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(30px);
            -webkit-backdrop-filter: blur(30px);
            border-radius: 20px;
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.6);
            padding: 24px;
            z-index: 1000;
            width: 380px;
            max-height: 85vh;
            overflow-y: auto;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .admin-panel {
                background: rgba(255, 255, 255, 0.08);
                border-color: rgba(255, 255, 255, 0.15);
                color: #fff;
            }
        }

        .admin-panel h3 {
            font-weight: 700;
            font-size: 16px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .admin-panel h3 {
                color: #fff;
            }
        }

        .form-group {
            margin-bottom: 14px;
        }

        .form-group label {
            display: block;
            font-size: 12px;
            font-weight: 600;
            opacity: 0.7;
            margin-bottom: 6px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .form-group label {
                color: rgba(255, 255, 255, 0.8);
            }
        }

        .admin-panel input, .admin-panel select {
            width: 100%;
            padding: 11px 14px;
            margin: 0;
            border: 1px solid rgba(0, 0, 0, 0.12);
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.9);
            color: black;
            font-size: 13px;
            transition: all 0.2s;
            font-family: 'Inter', sans-serif;
        }

        .admin-panel input:focus, .admin-panel select:focus {
            outline: none;
            border-color: #0ea5e9;
            background: white;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.12);
        }

        @media (prefers-color-scheme: dark) {
            .admin-panel input, .admin-panel select {
                background: rgba(50, 50, 50, 0.9);
                border-color: rgba(255, 255, 255, 0.12);
                color: white;
            }

            .admin-panel input:focus, .admin-panel select:focus {
                background: rgba(60, 60, 60, 0.95);
                border-color: #0ea5e9;
            }
        }

        .admin-panel button {
            width: 100%;
            padding: 12px 16px;
            margin-top: 10px;
            background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
            color: white;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 13px;
            font-weight: 600;
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
        }

        .admin-panel button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(14, 165, 233, 0.3);
        }

        .admin-panel button:active {
            transform: translateY(0);
        }

        .coords-display {
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.1) 0%, rgba(14, 165, 233, 0.05) 100%);
            border: 1.5px solid rgba(14, 165, 233, 0.25);
            border-radius: 12px;
            padding: 14px 16px;
            margin: 16px 0;
            font-size: 12px;
            font-family: 'Courier New', monospace;
            word-break: break-all;
            line-height: 1.6;
            backdrop-filter: blur(10px);
            transition: all 0.2s;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .coords-display {
                color: #fff;
            }
        }

        .coords-display.locked {
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.1) 0%, rgba(16, 185, 129, 0.05) 100%);
            border-color: rgba(16, 185, 129, 0.3);
            box-shadow: 0 0 16px rgba(16, 185, 129, 0.15);
        }

        .crosshair {
            position: fixed;
            width: 24px;
            height: 24px;
            pointer-events: none;
            display: none;
            z-index: 999;
            transform: translate(-50%, -50%);
        }

        .crosshair.active {
            display: block;
        }

        .crosshair::before {
            content: '';
            position: absolute;
            width: 24px;
            height: 24px;
            border: 2px solid #0ea5e9;
            border-radius: 50%;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 0 0 0 2px rgba(14, 165, 233, 0.2), inset 0 0 0 4px rgba(14, 165, 233, 0.1);
        }

        .crosshair::after {
            content: '';
            position: absolute;
            width: 2px;
            height: 8px;
            background: #0ea5e9;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 0 -12px 0 0 #0ea5e9, 0 12px 0 0 #0ea5e9, -12px 0 0 0 #0ea5e9, 12px 0 0 0 #0ea5e9;
        }

        .crosshair.locked::before {
            border-color: #10b981;
            box-shadow: 0 0 0 2px rgba(16, 185, 129, 0.2), inset 0 0 0 4px rgba(16, 185, 129, 0.1);
        }

        .crosshair.locked::after {
            background: #10b981;
            box-shadow: 0 -12px 0 0 #10b981, 0 12px 0 0 #10b981, -12px 0 0 0 #10b981, 12px 0 0 0 #10b981;
        }

        .notification {
            position: fixed;
            top: 100px;
            right: 24px;
            background: rgba(255, 255, 255, 0.9);
            border-left: 3px solid #10b981;
            padding: 16px 20px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.12);
            z-index: 2000;
            display: none;
            animation: slideIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-size: 14px;
            font-weight: 500;
            color: #000;
        }

        @media (prefers-color-scheme: dark) {
            .notification {
                background: rgba(255, 255, 255, 0.1);
                backdrop-filter: blur(20px);
                color: #fff;
            }
        }

        .notification.error {
            border-left-color: #ef4444;
        }

        @keyframes slideIn {
            from { transform: translateX(400px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        .notification.show {
            display: block;
        }
    </style>
</head>
<body class="bg-white dark:bg-black">
    <div class="search-wrapper">
        <div class="search-bar">
            <i class="fas fa-search"></i>
            <input type="text" id="searchInput" placeholder="Chercher un lieu...">
        </div>
        <div class="search-results" id="searchResults"></div>
    </div>

    <?php if ($adminMode): ?>
    <div class="admin-panel">
        <h3>
            <i class="fas fa-crosshairs"></i>
            Mode Admin
        </h3>
        <div class="form-group">
            <label>Nom du lieu</label>
            <input type="text" id="blipName" placeholder="Restaurant XYZ...">
        </div>
        <div class="form-group">
            <label>Categorie</label>
            <select id="blipType">
                <option value="restaurant">Restaurant</option>
                <option value="store">Magasin</option>
                <option value="florist">Fleuriste</option>
                <option value="catering">Traiteur</option>
                <option value="other">Autre</option>
            </select>
        </div>
        <div class="form-group">
            <label>Icone Font Awesome</label>
            <input type="text" id="blipIcon" placeholder="fa-utensils, fa-store...">
        </div>
        <div class="form-group">
            <label>URL du logo (optionnel)</label>
            <input type="text" id="blipUrl" placeholder="https://...">
        </div>
        
        <div class="coords-display" id="coordsDisplay">
            Cliquez sur la map pour selectionner
        </div>

        <button onclick="addBlipAtSelected()">
            Ajouter le blip
        </button>
        <button onclick="copyBlipsCode()" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); margin-top: 8px;">
            Copier le code PHP
        </button>
    </div>
    <?php endif; ?>

    <div class="crosshair" id="crosshair"></div>
    <div class="notification" id="notification"></div>
    <div id="map"></div>

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
        var adminMode = <?php echo json_encode($adminMode); ?>;
        var blipsData = <?php echo json_encode($blips); ?>;
        var zoneData = <?php echo json_encode($zoneData); ?>;
        var selectedCoords = null;
        var coordsLocked = false;

        var map = L.map('map', { zoomControl: false }).setView([zoneData.center.lat, zoneData.center.lng], zoneData.center.zoom);

        var lightTile = L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png', {
            maxZoom: 19,
            attribution: ''
        });

        var darkTile = L.tileLayer('https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png', {
            maxZoom: 19,
            attribution: ''
        });

        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            darkTile.addTo(map);
        } else {
            lightTile.addTo(map);
        }

        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', function(e) {
            map.removeLayer(e.matches ? lightTile : darkTile);
            map.addLayer(e.matches ? darkTile : lightTile);
        });

        var zoneCoords = zoneData.zone.map(function(p) { return [p.lat, p.lng]; });
        L.polygon(zoneCoords, {
            color: '#0ea5e9',
            weight: 2,
            opacity: 0.7,
            fillOpacity: 0.1,
            dashArray: '8, 4'
        }).addTo(map);

        var maxBounds = L.latLngBounds(zoneCoords).pad(0.0005);
        map.setMaxBounds(maxBounds);

        var userMarker = null;
        var targetPos = { lat: null, lng: null };
        var currentPos = { lat: null, lng: null };
        var lastUpdateTime = Date.now();
        var blipMarkers = {};

        var userIcon = L.divIcon({
            className: 'location-dot',
            iconSize: [20, 20],
            iconAnchor: [10, 10]
        });

        function createBlipIcon(icon, url) {
            var html;
            if (url) {
                html = '<img src="' + url + '" style="width:100%;height:100%;border-radius:50%;object-fit:cover;">';
            } else {
                html = '<i class="fas ' + icon + '"></i>';
            }
            return L.divIcon({
                className: 'blip-icon',
                html: html,
                iconSize: [44, 44],
                iconAnchor: [22, 22]
            });
        }

        function addBlipMarker(blip) {
            if (blipMarkers[blip.id]) {
                map.removeLayer(blipMarkers[blip.id]);
            }
            
            var icon = createBlipIcon(blip.icon, blip.url || null);
            var marker = L.marker([blip.lat, blip.lng], { icon: icon }).addTo(map);
            marker.bindPopup('<strong>' + blip.name + '</strong><br><small>' + blip.type + '</small>');
            blipMarkers[blip.id] = marker;
        }

        blipsData.forEach(function(blip) {
            addBlipMarker(blip);
        });

        function pointInPolygon(point, polygon) {
            var x = point.lat, y = point.lng;
            var inside = false;
            for (var i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
                var xi = polygon[i].lat, yi = polygon[i].lng;
                var xj = polygon[j].lat, yj = polygon[j].lng;
                var intersect = ((yi > y) !== (yj > y)) && (x < (xj - xi) * (y - yi) / (yj - yi) + xi);
                if (intersect) inside = !inside;
            }
            return inside;
        }

        function updateMarker() {
            if (targetPos.lat === null) {
                requestAnimationFrame(updateMarker);
                return;
            }

            if (currentPos.lat === null) {
                currentPos.lat = targetPos.lat;
                currentPos.lng = targetPos.lng;
            }

            var now = Date.now();
            var deltaTime = (now - lastUpdateTime) / 16.67;
            lastUpdateTime = now;

            var smoothFactor = Math.min(0.12 * deltaTime, 1);
            currentPos.lat += (targetPos.lat - currentPos.lat) * smoothFactor;
            currentPos.lng += (targetPos.lng - currentPos.lng) * smoothFactor;

            var isInside = pointInPolygon({ lat: currentPos.lat, lng: currentPos.lng }, zoneData.zone);

            if (isInside) {
                if (!userMarker) {
                    userMarker = L.marker([currentPos.lat, currentPos.lng], {icon: userIcon}).addTo(map);
                } else {
                    userMarker.setLatLng([currentPos.lat, currentPos.lng]);
                }
            } else {
                if (userMarker) {
                    map.removeLayer(userMarker);
                    userMarker = null;
                }
            }

            requestAnimationFrame(updateMarker);
        }

        navigator.geolocation.watchPosition(function(position) {
            targetPos.lat = position.coords.latitude;
            targetPos.lng = position.coords.longitude;
        }, function(error) {
            console.error('GPS error:', error);
        }, { enableHighAccuracy: true, maximumAge: 0, timeout: 5000 });

        updateMarker();

        if (adminMode) {
            var crosshair = document.getElementById('crosshair');
            var coordsDisplay = document.getElementById('coordsDisplay');

            map.on('mousemove', function(e) {
                if (coordsLocked) return;
                
                crosshair.classList.add('active');
                crosshair.classList.remove('locked');
                crosshair.style.left = e.originalEvent.clientX + 'px';
                crosshair.style.top = e.originalEvent.clientY + 'px';
            });

            map.on('click', function(e) {
                selectedCoords = e.latlng;
                coordsLocked = true;

                crosshair.classList.add('locked');
                crosshair.style.left = e.originalEvent.clientX + 'px';
                crosshair.style.top = e.originalEvent.clientY + 'px';

                var latStr = e.latlng.lat.toFixed(8);
                var lngStr = e.latlng.lng.toFixed(8);
                coordsDisplay.textContent = 'Lat: ' + latStr + '\nLng: ' + lngStr;
                coordsDisplay.classList.add('locked');

                showNotification('Coordonnees verrouillee');
            });

            map.on('mouseleave', function() {
                if (!coordsLocked) {
                    crosshair.classList.remove('active');
                }
            });

            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && coordsLocked) {
                    coordsLocked = false;
                    crosshair.classList.remove('locked');
                    coordsDisplay.textContent = 'Cliquez sur la map pour selectionner';
                    coordsDisplay.classList.remove('locked');
                    showNotification('Selection annulee');
                }
            });
        }

        var searchInput = document.getElementById('searchInput');
        var searchResults = document.getElementById('searchResults');

        searchInput.addEventListener('input', function() {
            var query = this.value.trim().toLowerCase();
            searchResults.innerHTML = '';

            if (query.length < 1) {
                searchResults.classList.remove('active');
                return;
            }

            var results = blipsData.filter(function(blip) {
                return blip.name.toLowerCase().indexOf(query) !== -1;
            });

            if (results.length === 0) {
                searchResults.classList.remove('active');
                return;
            }

            results.forEach(function(result) {
                var item = document.createElement('div');
                item.className = 'search-result-item';
                
                var content = document.createElement('div');
                content.className = 'search-result-content';
                content.innerHTML = '<div class="search-result-name">' + result.name + '</div><div class="search-result-type">' + result.type + '</div>';
                
                var isInZone = pointInPolygon({lat: result.lat, lng: result.lng}, zoneData.zone);
                
                var button = document.createElement('button');
                button.className = 'search-result-action';
                button.textContent = 'S\'y rendre';
                button.disabled = !isInZone;
                button.title = isInZone ? '' : 'Hors zone';
                
                button.onclick = function(e) {
                    e.stopPropagation();
                    if (isInZone) {
                        navigateToBlip(result);
                    } else {
                        showNotification('Ce lieu est hors de la zone accessible', true);
                    }
                };
                
                item.appendChild(content);
                item.appendChild(button);
                searchResults.appendChild(item);
            });

            searchResults.classList.add('active');
        });

        document.addEventListener('click', function(e) {
            var searchWrapper = e.target.closest('.search-wrapper');
            if (!searchWrapper) {
                searchResults.classList.remove('active');
            }
        });

        function navigateToBlip(blip) {
            map.flyTo([blip.lat, blip.lng], 18, { duration: 1 });
            setTimeout(function() {
                blipMarkers[blip.id].openPopup();
            }, 600);
            
            searchResults.classList.remove('active');
            searchInput.value = '';
            showNotification('Direction vers ' + blip.name);
        }

        function showNotification(message, isError) {
            var notif = document.getElementById('notification');
            notif.textContent = message;
            notif.classList.add('show');
            if (isError) {
                notif.classList.add('error');
            } else {
                notif.classList.remove('error');
            }
            setTimeout(function() {
                notif.classList.remove('show');
            }, 3000);
        }

        function addBlipAtSelected() {
            if (!adminMode || !selectedCoords) {
                showNotification('Verrouillez dabord les coordonnees en cliquant', true);
                return;
            }

            var name = document.getElementById('blipName').value;
            var type = document.getElementById('blipType').value;
            var icon = document.getElementById('blipIcon').value;
            var url = document.getElementById('blipUrl').value;

            if (!name || !icon) {
                showNotification('Remplissez le nom et licone', true);
                return;
            }

            var maxId = 0;
            blipsData.forEach(function(b) {
                if (b.id > maxId) maxId = b.id;
            });

            var newBlip = {
                id: maxId + 1,
                name: name,
                lat: selectedCoords.lat,
                lng: selectedCoords.lng,
                type: type,
                icon: icon,
                url: url || null
            };

            blipsData.push(newBlip);
            addBlipMarker(newBlip);
            document.getElementById('blipName').value = '';
            document.getElementById('blipIcon').value = '';
            document.getElementById('blipUrl').value = '';
            
            coordsLocked = false;
            var crosshair = document.getElementById('crosshair');
            crosshair.classList.remove('locked');
            var coordsDisplay = document.getElementById('coordsDisplay');
            coordsDisplay.textContent = 'Cliquez sur la map pour selectionner';
            coordsDisplay.classList.remove('locked');
            
            showNotification('Blip ajoute avec succes');
        }

        function copyBlipsCode() {
            if (!adminMode) return;
            var code = '$blips = ' + JSON.stringify(blipsData, null, 4) + ';';
            navigator.clipboard.writeText(code).then(function() {
                showNotification('Code PHP copie');
            });
        }
    </script>
</body>
</html>