<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paiement Sécurisé</title>
    <script src="https://js.stripe.com/v3/"></script>
    <style>
        body {
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, sans-serif;
            background: white;
            padding: 40px 20px;
        }
        .container {
            max-width: 400px;
            margin: 0 auto;
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        .price {
            font-size: 48px;
            font-weight: 700;
            color: #16a34a;
            margin-bottom: 8px;
        }
        .period {
            color: #666;
            font-size: 18px;
            margin-bottom: 40px;
        }
        
        #payment-request-button {
            margin-bottom: 30px;
        }
        
        .divider {
            text-align: center;
            margin: 30px 0;
            position: relative;
            color: #999;
            font-size: 14px;
        }
        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background: #e0e0e0;
            z-index: 1;
        }
        .divider span {
            background: white;
            padding: 0 15px;
            position: relative;
            z-index: 2;
        }
        
        #card-element {
            padding: 16px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            margin-bottom: 20px;
            background: white;
        }
        
        #submit-button {
            width: 100%;
            background: #16a34a;
            color: white;
            border: none;
            padding: 16px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }
        #submit-button:hover {
            background: #15803d;
        }
        #submit-button:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        
        .message {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
        }
        .success { color: #16a34a; font-weight: 600; }
        .error { color: #dc2626; font-weight: 600; }
        
        .loading {
            text-align: center;
            margin: 40px 0;
        }
        .spinner {
            width: 24px;
            height: 24px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #16a34a;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 15px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="price">1,99€</div>
            <div class="period">par mois</div>
        </div>
        
        <div id="payment-request-button"></div>
        
        <div class="divider">
            <span>ou par carte</span>
        </div>
        
        <form id="payment-form">
            <div id="card-element"></div>
            <button type="submit" id="submit-button">
                S'abonner maintenant
            </button>
            <div id="payment-message" class="message"></div>
        </form>
    </div>

    <script>
        const stripe = Stripe('pk_live_51LmhGsHQanXHoJn0qgKjMAisGwy6TzfZyUnzSq2Yc9qDmAQv8Syu9wuFDZVjgpg8kWUxm9bQ8MMi8E3WwNayGXus00Oe5tyNIP');
        
        const urlParams = new URLSearchParams(window.location.search);
        const residentId = urlParams.get('resident_id');
        
        if (!residentId) {
            showMessage('ID utilisateur manquant', 'error');
        } else {
            initializePayment();
        }

        let elements;
        let cardElement;

        async function initializePayment() {
            elements = stripe.elements({
                appearance: {
                    theme: 'stripe',
                    variables: {
                        colorPrimary: '#16a34a',
                    }
                }
            });

            cardElement = elements.create('card', {
                style: {
                    base: {
                        fontSize: '16px',
                        color: '#424770',
                        '::placeholder': {
                            color: '#aab7c4',
                        },
                    },
                },
            });
            cardElement.mount('#card-element');

            setupApplePayGooglePay();
        }

        async function setupApplePayGooglePay() {
            const paymentRequest = stripe.paymentRequest({
                country: 'BE',
                currency: 'eur',
                total: {
                    label: 'Abonnement Premium Vert Chasseur',
                    amount: 199,
                },
                requestPayerName: true,
                requestPayerEmail: true,
            });

            const prButton = elements.create('paymentRequestButton', {
                paymentRequest: paymentRequest,
                style: {
                    paymentRequestButton: {
                        type: 'default',
                        theme: 'dark',
                        height: '50px',
                    }
                }
            });

            const canMakePayment = await paymentRequest.canMakePayment();
            if (canMakePayment) {
                prButton.mount('#payment-request-button');
            } else {
                document.getElementById('payment-request-button').style.display = 'none';
                document.querySelector('.divider').style.display = 'none';
            }

            paymentRequest.on('paymentmethod', async (ev) => {
                const result = await processSubscription(ev.paymentMethod.id);
                
                if (result.success) {
                    ev.complete('success');
                    showSuccess();
                } else {
                    ev.complete('fail');
                    showMessage(result.error || 'Erreur lors du paiement', 'error');
                }
            });
        }

        document.getElementById('payment-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            setLoading(true);

            const { error, paymentMethod } = await stripe.createPaymentMethod({
                type: 'card',
                card: cardElement,
            });

            if (error) {
                showMessage(error.message, 'error');
                setLoading(false);
            } else {
                const result = await processSubscription(paymentMethod.id);
                
                if (result.success) {
                    showSuccess();
                } else {
                    showMessage(result.error || 'Erreur lors du paiement', 'error');
                    setLoading(false);
                }
            }
        });

        async function processSubscription(paymentMethodId) {
            const response = await fetch('../create-subscription.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    payment_method_id: paymentMethodId,
                    resident_id: residentId
                })
            });

            return await response.json();
        }

        function showSuccess() {
            showMessage('Paiement réussi ! Fermeture...', 'success');
            setTimeout(() => {
                if (window.parent) {
                    window.parent.postMessage({ success: true }, '*');
                }
            }, 2000);
        }

        function showMessage(text, type = '') {
            const messageEl = document.getElementById('payment-message');
            messageEl.textContent = text;
            messageEl.className = 'message ' + type;
        }

        function setLoading(loading) {
            const button = document.getElementById('submit-button');
            if (loading) {
                button.disabled = true;
                button.innerHTML = '<div class="spinner"></div>';
            } else {
                button.disabled = false;
                button.textContent = 'S\'abonner maintenant';
            }
        }
    </script>
</body>
</html>