<?php
session_start();
include 'header-mobile.php';
include 'db.php';

if (!isset($_SESSION['resident_id'])) {
    header('Location: login.php');
    exit;
}

$resident_id = $_SESSION['resident_id'];
$stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$resident = $stmt->get_result()->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Club Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <style>
        @media (min-width: 768px) {
            body {
                background-image: url('font-homepage.png');
                background-size: cover;
                background-position: center;
                background-attachment: fixed;
                background-repeat: no-repeat;
            }
        }

        @media (max-width: 767px) {
            body {
                background-color: #ffffff !important;
                background-image: none !important;
            }
            .dark body {
                background-color: #000000 !important;
                background-image: none !important;
            }
        }

        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }

        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300">
    <script>
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>

    <main class="min-h-screen px-4 py-8 md:py-16">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-center justify-center mb-8 md:mb-12 text-center relative">

                <h1 class="mt-4 md:mt-12 text-3xl md:text-5xl lg:text-6xl font-light text-stone-800 dark:text-white mb-2 md:mb-3 tracking-tight">
                    <span class="txt-chasseur text-green-600">Club</span> Vert Chasseur
                </h1>
                <p class="text-lg md:text-xl text-stone-600 dark:text-stone-400 font-light">
                    Ton espace d'activités communautaires
                </p>
            </div>

            <div class="max-w-4xl mx-auto">
                <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30 mb-8">
                    <div class="text-center mb-8">
                        <div class="inline-block bg-amber-100 dark:bg-amber-900/30 px-4 py-2 rounded-full text-amber-800 dark:text-amber-300 text-sm font-medium mb-6">
                            Bientôt disponible
                        </div>
                        
                        <h2 class="text-2xl md:text-3xl font-light text-stone-800 dark:text-white mb-4 tracking-tight">
                            Une nouvelle expérience arrive
                        </h2>
                        
                        <p class="text-base md:text-lg text-stone-600 dark:text-stone-400 leading-relaxed">
                            Le Club Vert Chasseur se transforme pour t'offrir des activités variées, organisées et encadrées de manière sécurisée par nos agents.
                        </p>
                    </div>

                    <div class="bg-stone-50 dark:bg-stone-800/50 rounded-xl p-6 mb-6">
                        <div class="text-center">
                            <p class="text-lg md:text-xl font-semibold text-stone-900 dark:text-white mb-2">
                                Ouverture : 15 Mars 2026
                            </p>
                            <p class="text-sm text-stone-600 dark:text-stone-400">
                                Activités disponibles jusqu'en Juin 2026
                            </p>
                        </div>
                    </div>

                    <div class="space-y-4 text-sm md:text-base text-stone-700 dark:text-stone-300">
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p>Des activités variées pour tous les âges et tous les goûts</p>
                        </div>
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p>Encadrement professionnel par des agents Vert Chasseur certifiés</p>
                        </div>
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p>Environnement sécurisé pour toute la communauté</p>
                        </div>
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p>Horaires flexibles adaptés à ton emploi du temps</p>
                        </div>
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p>Rencontre tes voisins dans un cadre convivial</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30">
                    <h3 class="text-xl md:text-2xl font-light text-stone-800 dark:text-white mb-4 tracking-tight">Informations pratiques</h3>
                    
                    <div class="space-y-3 text-sm md:text-base text-stone-600 dark:text-stone-400">
                        <p>
                            <strong class="text-stone-900 dark:text-white">Ouverture :</strong> Le Club Vert Chasseur ouvrira ses portes le 15 Mars 2026
                        </p>
                        <p>
                            <strong class="text-stone-900 dark:text-white">Période d'activité :</strong> Les activités seront proposées de Mars à Juin 2026
                        </p>
                        <p>
                            <strong class="text-stone-900 dark:text-white">Inscription :</strong> Les inscriptions aux activités ouvriront début Mars
                        </p>
                        <p>
                            <strong class="text-stone-900 dark:text-white">Notification :</strong> Tu recevras une notification sur l'application dès l'ouverture
                        </p>
                    </div>

                    <div class="mt-6 p-4 bg-stone-50 dark:bg-stone-800/50 rounded-xl">
                        <p class="text-sm text-stone-600 dark:text-stone-400">
                            <strong class="text-stone-900 dark:text-white">Une question ?</strong> Contacte-nous via le bouton d'aide sur la page d'accueil
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="w-full py-4 md:py-6 border-t border-stone-200 dark:border-stone-800 mt-16">
        <p class="text-xs text-stone-500 dark:text-stone-400 text-center px-4">
            © 2025 Vert Chasseur · 
            <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member
        </p>
    </footer>
</body>
</html>