<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Bêta Test Android - Vert Chasseur</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background-color: #ffffff;
        }
        .dark body {
            background-color: #000000;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
    </style>
</head>
<body class="transition-colors duration-300">
<?php 
include 'header.php';
include 'db.php';

$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
    
    if ($email) {
        $email = $conn->real_escape_string($email);
        
        $check = $conn->query("SELECT * FROM `beta-tester` WHERE mail = '$email'");
        
        if ($check->num_rows > 0) {
            $error = 'Cette adresse email est déjà inscrite.';
        } else {
            $result = $conn->query("INSERT INTO `beta-tester` (mail) VALUES ('$email')");
            
            if ($result) {
                $success = true;
            } else {
                $error = 'Une erreur est survenue. Veuillez réessayer.';
            }
        }
    } else {
        $error = 'Veuillez saisir une adresse email valide.';
    }
}

$conn->close();
?>

<script>
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        document.documentElement.classList.add('dark');
    }
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    });
</script>

<main class="min-h-screen flex items-center justify-center px-8 py-32">
    <div class="max-w-md w-full">
        <div class="text-center mb-12">
            <p class="text-stone-500 dark:text-stone-400 text-xs tracking-widest uppercase mb-4 font-light">Accès anticipé</p>
            <h1 class="text-4xl md:text-5xl font-light mb-6 text-stone-800 dark:text-white tracking-tight">
                Bêta Test pour Android
            </h1>
            <p class="text-lg text-stone-600 dark:text-stone-400 leading-relaxed font-light">
                Sois parmi les premiers à tester l'application Vert Chasseur sur Android avant sa sortie officielle.
            </p>
        </div>

        <?php if ($success): ?>
        <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-xl p-8 text-center">
            <i class="fas fa-check-circle text-green-500 text-5xl mb-4"></i>
            <h2 class="text-2xl font-medium text-stone-900 dark:text-white mb-3">Inscription confirmée</h2>
            <p class="text-stone-600 dark:text-stone-400 leading-relaxed">
                Tu recevras un email sous 24h avec les instructions pour accéder à la version bêta Android par les services Google.
            </p>
        </div>
        <?php else: ?>
        <form method="POST" class="space-y-6">
            <?php if ($error): ?>
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                <p class="text-red-800 dark:text-red-200 text-sm"><?php echo htmlspecialchars($error); ?></p>
            </div>
            <?php endif; ?>

            <div>
                <label class="block text-sm text-stone-600 dark:text-stone-400 mb-2 font-light">Ton adresse email</label>
                <input 
                    type="email" 
                    name="email" 
                    placeholder="ton@email.com" 
                    required 
                    class="w-full px-4 py-3 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-900 text-stone-900 dark:text-white text-base focus:outline-none focus:ring-2 focus:ring-stone-400 dark:focus:ring-stone-600 transition-all"
                >
            </div>

            <button 
                type="submit" 
                class="w-full px-6 py-3 bg-stone-900 dark:bg-white text-white dark:text-stone-900 rounded-lg font-medium text-base hover:bg-stone-800 dark:hover:bg-stone-100 transition-colors"
            >
                Rejoindre la bêta
            </button>

            <p class="text-xs text-stone-500 dark:text-stone-400 text-center leading-relaxed">
                En t'inscrivant, tu acceptes de recevoir des emails concernant le programme bêta. Tu recevras les instructions d'accès sous 24h.
            </p>
        </form>
        <?php endif; ?>
    </div>
</main>

<footer class="w-full py-6 px-8 md:px-16 border-t border-stone-200 dark:border-stone-800">
    <p class="text-xs text-stone-500 dark:text-stone-400">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member</p>
</footer>

</body>
</html>