<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
    exit;
}

if (!isset($_FILES['image'])) {
    echo json_encode(['success' => false, 'error' => 'No image provided']);
    exit;
}

$file = $_FILES['image'];
$userId = $_POST['userId'];
$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];

if (!in_array($file['type'], $allowedTypes)) {
    echo json_encode(['success' => false, 'error' => 'Invalid file type']);
    exit;
}

$filename = 'profile_' . $userId . '_' . time() . '.jpg';
$uploadPath = __DIR__ . '/uploads/' . $filename;

if (!file_exists(__DIR__ . '/uploads/')) {
    mkdir(__DIR__ . '/uploads/', 0755, true);
}

if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
    $url = 'https://imators.systems/api-court/uploads/' . $filename;
    echo json_encode(['success' => true, 'url' => $url]);
} else {
    echo json_encode(['success' => false, 'error' => 'Upload failed']);
}
?>