<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
    exit;
}

if (!isset($_FILES['image'])) {
    echo json_encode(['success' => false, 'error' => 'No image provided']);
    exit;
}

$file = $_FILES['image'];
$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];

if (!in_array($file['type'], $allowedTypes)) {
    echo json_encode(['success' => false, 'error' => 'Invalid file type']);
    exit;
}

$filename = uniqid() . '_' . time() . '.jpg';
$cdnPath = '../cdn.imators.com/court/profiles/';

if (!file_exists($cdnPath)) {
    mkdir($cdnPath, 0777, true);
}

$uploadPath = $cdnPath . $filename;

if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
    $url = 'https://cdn.imators.com/court/profiles/' . $filename;
    echo json_encode(['success' => true, 'url' => $url]);
} else {
    echo json_encode(['success' => false, 'error' => 'Upload failed']);
}
?>