<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Updates - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
    </style>
</head>
<body>
<?php include 'src/header.php'; ?>

    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl font-light mb-6 mt-24">Latest Updates.</h1>
        <p class="text-xl text-gray-400 mb-12">Discover the latest improvements and updates to our applications.</p>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">TrafficLight & API</h3>
                <p class="text-sm text-gray-500 mt-1">v1.3</p>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">Now available on the App Store, with new intelligent features such as the addition of a new red light when a user stops, and the ability to make journeys 25% faster than the norm.</p>
                <p class="text-sm text-gray-500 mt-2">April 19, 2025</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://imators.systems/traffic" class="text-link">Go to the application →</a>
            </div>
        </div>
        <div class="separator"></div>

        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light">Imators Systems</h3>
                <p class="text-sm text-gray-500 mt-1">v1.5</p>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400">Setting up a production server to share a project with testers so that they can experiment with it, adding Claude to the dashboard to enable rapid modification of an application by targeting functions.</p>
                <p class="text-sm text-gray-500 mt-2">April 19, 2025</p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://imators.systems" class="text-link">Go to the application →</a>
            </div>
        </div>
        <div class="separator"></div>
        
        <div class="py-10">
            <h2 class="text-2xl font-light mb-8">Stay Updated</h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2">Notifications</h3>
                    <p class="text-gray-400 mb-2">Enable notifications to receive the latest updates.</p>
                    <a href="https://idsma.imators.com/login" class="text-link">Manage Notifications →</a>
                </div>
                
            </div>
        </div>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

    <div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
        <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
            <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
                Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use</a>.
            </div>
            <button onclick="acceptCookies()" class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium">
                Accept
            </button>
        </div>
    </div>

    <script>
        function acceptCookies() {
            const cookieBox = document.getElementById('cookieBox');
            cookieBox.classList.add('opacity-0', 'translate-y-8');
            
            setTimeout(() => {
                cookieBox.style.display = 'none';
                localStorage.setItem('cookiesAccepted', 'true');
            }, 500);
        }

        window.onload = function() {
            const cookieBox = document.getElementById('cookieBox');
            
            if (localStorage.getItem('cookiesAccepted') === 'true') {
                cookieBox.style.display = 'none';
            } else {
                setTimeout(() => {
                    cookieBox.classList.remove('opacity-0', 'translate-y-8');
                }, 2000);
            }
        }
    </script>
</body>
</html>