<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TrafficLight - Maintenance</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, sans-serif;
            background-color: #000;
            color: #fff;
            margin: 0;
            padding: 40px;
            line-height: 1.6;
        }
        .container {
            max-width: 900px;
            margin: 60px auto;
        }
        h1 {
            font-size: 80px;
            margin: 0;
            font-weight: 700;
        }
        .error-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 40px;
            margin-top: 60px;
        }
        .error-reason {
            padding: 20px;
        }
        .icon {
            font-size: 24px;
            margin-bottom: 15px;
        }
        .reason-title {
            font-size: 18px;
            margin-bottom: 10px;
            font-weight: 500;
        }
        p {
            margin: 0;
            color: #888;
        }
        .back-link {
            display: inline-block;
            color: #fff;
            text-decoration: none;
            margin-top: 60px;
            border: 1px solid #333;
            padding: 15px 30px;
        }
        .back-link:hover {
            background: #111;
        }
        .language-toggle {
            position: absolute;
            top: 20px;
            right: 20px;
        }
        .language-btn {
            background: none;
            color: #fff;
            border: 1px solid #333;
            padding: 5px 10px;
            cursor: pointer;
            margin-left: 5px;
        }
        .language-btn:hover {
            background: #111;
        }
        .en, .fr {
            display: none;
        }
        .active {
            display: block;
        }
        @media (max-width: 600px) {
            body {
                padding: 20px;
            }
            h1 {
                font-size: 60px;
            }
            .error-grid {
                gap: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="language-toggle">
        <button class="language-btn" onclick="toggleLanguage('en')">EN</button>
        <button class="language-btn" onclick="toggleLanguage('fr')">FR</button>
    </div>

    <div class="container en">
        <h1 class="text-5xl">Maintenance until March 27.</h1>
        <p>TrafficLight is currently undergoing maintenance. We expect to be back online soon. The maintenance includes:</p>
        <div class="error-grid">
            <div class="error-reason">
                <i class="icon fas fa-server"></i>
                <div class="reason-title">TrafficL-API</div>
                <p>We built the application API to allow general use by services such as Waze and many others</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-database"></i>
                <div class="reason-title">Database Optimization</div>
                <p>Optimizing our databases for faster response times</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-code"></i>
                <div class="reason-title">New Features</div>
                <p>We're adding exciting new features to enhance your experience</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-bug"></i>
                <div class="reason-title">Bug Fixes</div>
                <p>Addressing known issues to improve system stability</p>
            </div>
        </div>
        <a href="/" class="back-link">Check Status</a>
    </div>

    <div class="container fr">
        <h1 class="text-5xl">Maintenance jusqu’au 27 mars.</h1>
        <p>TrafficLight est actuellement en maintenance. Nous prévoyons d'être de retour en ligne bientôt. La maintenance comprend :</p>
        <div class="error-grid">
            <div class="error-reason">
                <i class="icon fas fa-server"></i>
                <div class="reason-title">TrafficL-API</div>
                <p>Nous avons construit l’API de l’application pour permettre une utilisation générale par des services tels que Waze et bien d’autres</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-database"></i>
                <div class="reason-title">Optimisation de la base de données</div>
                <p>Optimisation de nos bases de données pour des temps de réponse plus rapides</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-code"></i>
                <div class="reason-title">Nouvelles fonctionnalités</div>
                <p>Nous ajoutons de nouvelles fonctionnalités passionnantes pour améliorer votre expérience</p>
            </div>
            <div class="error-reason">
                <i class="icon fas fa-bug"></i>
                <div class="reason-title">Corrections de bugs</div>
                <p>Résolution des problèmes connus pour améliorer la stabilité du système</p>
            </div>
        </div>
        <a href="/" class="back-link">Vérifier l'état</a>
    </div>

    <script>
        function toggleLanguage(lang) {
            document.querySelectorAll('.en, .fr').forEach(el => {
                el.classList.remove('active');
            });
            document.querySelector('.' + lang).classList.add('active');
        }
        
        // Set default language based on browser settings
        const userLang = navigator.language || navigator.userLanguage;
        if (userLang.startsWith('fr')) {
            toggleLanguage('fr');
        } else {
            toggleLanguage('en');
        }
    </script>
</body>
</html>