<?php
require_once 'db.php';

$data = json_decode(file_get_contents('php://input'), true);

if ($data && isset($data['visit_id'])) {
    $visit_id = intval($data['visit_id']);
    $user_id = $data['user_id'];
    $element_type = $data['element_type'];
    $element_text = $data['element_text'];
    $element_id = $data['element_id'];
    $element_class = $data['element_class'];
    $click_x = intval($data['click_x']);
    $click_y = intval($data['click_y']);
    $page_url = $data['page_url'];
    $click_time = date('Y-m-d H:i:s');
    
    $stmt = $conn->prepare("INSERT INTO `track-imators-clicks` (visit_id, user_id, element_type, element_text, element_id, element_class, click_x, click_y, page_url, click_time) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssssiiss", $visit_id, $user_id, $element_type, $element_text, $element_id, $element_class, $click_x, $click_y, $page_url, $click_time);
    $stmt->execute();
    $stmt->close();
}
?>
