<?php
session_start();
require_once 'db.php';
require_once 'verify-sso.php';

$sso_token = $_GET['sso_token'] ?? '';
if (empty($sso_token)) {
    die('Token SSO manquant');
}

$sso_verification = verifySSO($sso_token);
if (!$sso_verification['valid']) {
    die('Token SSO invalide ou expiré');
}

$resident_id = $sso_verification['user_id'];
$_SESSION['resident_id'] = $resident_id;
$_SESSION['sso_auth'] = true;

$stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$resident = $stmt->get_result()->fetch_assoc();

if (!$resident) {
    die('Utilisateur introuvable');
}

$existing_sub = $conn->prepare("SELECT * FROM subscriptions WHERE resident_id = ? AND status IN ('active', 'trialing')");
$existing_sub->bind_param("i", $resident_id);
$existing_sub->execute();
$subscription = $existing_sub->get_result()->fetch_assoc();

if ($subscription) {
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Abonnement actif</title>
    </head>
    <body>
        <script>
            if (window.ReactNativeWebView) {
                window.ReactNativeWebView.postMessage(JSON.stringify({
                    type: 'subscription_already_active',
                    success: true
                }));
            } else {
                window.close();
            }
        </script>
    </body>
    </html>
    <?php
    exit;
}

$stripe_config = require 'config/stripe.php';

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.stripe.com/v1/checkout/sessions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer " . $stripe_config['secret_key'],
        "Content-Type: application/x-www-form-urlencoded"
    ],
    CURLOPT_POSTFIELDS => http_build_query([
        'mode' => 'subscription',
        'line_items[0][price]' => $stripe_config['price_id'],
        'line_items[0][quantity]' => 1,
        'success_url' => 'https://imators.systems/vertchasseur/success.php?session_id={CHECKOUT_SESSION_ID}',
        'cancel_url' => 'https://imators.systems/vertchasseur/cancel.php',
        'customer_email' => $resident['email'],
        'client_reference_id' => $resident_id,
        'metadata[resident_id]' => $resident_id,
        'allow_promotion_codes' => 'true',
        'billing_address_collection' => 'auto',
        'payment_method_types[0]' => 'card',
        'subscription_data[metadata][resident_id]' => $resident_id
    ])
]);

$response = curl_exec($curl);
$error = curl_error($curl);
curl_close($curl);

if ($error) {
    die("Erreur Stripe: " . $error);
}

$session = json_decode($response, true);

if (isset($session['error'])) {
    die("Erreur Stripe: " . $session['error']['message']);
}

header('Location: ' . $session['url']);
exit;