<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adhésion - Hizhat</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@200;300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .reveal { opacity: 0; transform: translateY(30px); transition: all 0.8s ease; }
        .reveal.show { opacity: 1; transform: translateY(0); }

        .hamburger { width: 24px; height: 18px; position: relative; cursor: pointer; z-index: 60; }
        .hamburger span { 
            display: block; 
            position: absolute; 
            height: 2px; 
            width: 100%; 
            background: white; 
            transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            border-radius: 1px;
        }
        .hamburger span:nth-child(1) { top: 0; }
        .hamburger span:nth-child(2) { top: 8px; }
        .hamburger span:nth-child(3) { bottom: 0; }
        
        .hamburger.open span:nth-child(1) { 
            transform: rotate(45deg); 
            top: 8px; 
        }
        .hamburger.open span:nth-child(2) { 
            opacity: 0; 
            transform: scale(0);
        }
        .hamburger.open span:nth-child(3) { 
            transform: rotate(-45deg); 
            bottom: 8px; 
        }
        
        .fullscreen-menu {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: black;
            z-index: 50;
            transform: translateY(-100%);
            transition: transform 0.6s cubic-bezier(0.77, 0, 0.175, 1);
            backdrop-filter: blur(20px);
        }
        
        .fullscreen-menu.open {
            transform: translateY(0);
        }
        
        .menu-item {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.6s cubic-bezier(0.77, 0, 0.175, 1);
        }
        
        .fullscreen-menu.open .menu-item {
            opacity: 1;
            transform: translateY(0);
        }
        
        .menu-item:nth-child(1) { transition-delay: 0.1s; }
        .menu-item:nth-child(2) { transition-delay: 0.2s; }
        .menu-item:nth-child(3) { transition-delay: 0.3s; }
        .menu-item:nth-child(4) { transition-delay: 0.4s; }
        .menu-item:nth-child(5) { transition-delay: 0.5s; }

        .subscription-form input,
        .subscription-form select,
        .subscription-form textarea {
            background: transparent;
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 12px 16px;
            width: 100%;
            transition: all 0.3s ease;
        }

        .subscription-form input:focus,
        .subscription-form select:focus,
        .subscription-form textarea:focus {
            outline: none;
            border-color: white;
            background: rgba(255, 255, 255, 0.05);
        }

        .subscription-form input::placeholder,
        .subscription-form textarea::placeholder {
            color: rgba(255, 255, 255, 0.5);
        }

        .subscription-form select option {
            background: black;
            color: white;
        }

        .checkbox-container {
            position: relative;
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .checkbox-container input[type="checkbox"] {
            opacity: 0;
            position: absolute;
            width: 20px;
            height: 20px;
        }

        .checkmark {
            width: 20px;
            height: 20px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            margin-right: 12px;
            position: relative;
            transition: all 0.3s ease;
        }

        .checkbox-container input[type="checkbox"]:checked + .checkmark {
            background: white;
            border-color: white;
        }

        .checkbox-container input[type="checkbox"]:checked + .checkmark::after {
            content: '✓';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: black;
            font-size: 12px;
            font-weight: bold;
        }

        .price-highlight {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
        }

        @media (max-width: 768px) {
            .subscription-form {
                padding: 0 1rem;
            }
        }
    </style>
</head>
<body class="bg-black text-white overflow-x-hidden">

<header class="fixed top-0 w-full z-40 bg-black border-b border-white/20">
    <div class="max-w-none px-8 py-6 flex justify-between items-center">
        <div class="text-2xl font-extralight tracking-[0.3em]">
            <a href="/">HIZHAT</a>
        </div>
        <nav class="hidden lg:flex gap-12">
            <a href="index.html#hero" class="text-sm tracking-[0.15em] relative group">
                ACCUEIL
                <div class="absolute -bottom-1 left-0 w-0 h-px bg-white group-hover:w-full transition-all duration-300"></div>
            </a>
            <a href="index.html#advantages" class="text-sm tracking-[0.15em] relative group">
                AVANTAGES
                <div class="absolute -bottom-1 left-0 w-0 h-px bg-white group-hover:w-full transition-all duration-300"></div>
            </a>
            <a href="#" class="text-sm tracking-[0.15em] relative group">
                ADHÉSION
                <div class="absolute -bottom-1 left-0 w-full h-px bg-white"></div>
            </a>
            <a href="index.html#about" class="text-sm tracking-[0.15em] relative group">
                HISTOIRE
                <div class="absolute -bottom-1 left-0 w-0 h-px bg-white group-hover:w-full transition-all duration-300"></div>
            </a>
            <a href="index.html#gallery" class="text-sm tracking-[0.15em] relative group">
                GALERIE
                <div class="absolute -bottom-1 left-0 w-0 h-px bg-white group-hover:w-full transition-all duration-300"></div>
            </a>
        </nav>
        <div class="lg:hidden hamburger" onclick="toggleMenu()">
            <span></span><span></span><span></span>
        </div>
    </div>
</header>

<div class="fullscreen-menu">
    <div class="absolute top-6 right-6 lg:hidden">
        <div class="hamburger open" onclick="closeMenu()">
            <span></span><span></span><span></span>
        </div>
    </div>
    <div class="flex items-center justify-center h-full px-6">
        <nav class="text-center">
            <div class="menu-item">
                <a href="/" onclick="closeMenu()" class="block text-3xl lg:text-6xl font-extralight mb-6 lg:mb-8 tracking-[0.3em] hover:text-white/70 transition-all">ACCUEIL</a>
            </div>
            <div class="menu-item">
                <a href="index.html#advantages" onclick="closeMenu()" class="block text-3xl lg:text-6xl font-extralight mb-6 lg:mb-8 tracking-[0.3em] hover:text-white/70 transition-all">AVANTAGES</a>
            </div>
            <div class="menu-item">
                <a href="#" onclick="closeMenu()" class="block text-3xl lg:text-6xl font-extralight mb-6 lg:mb-8 tracking-[0.3em] hover:text-white/70 transition-all">ADHÉSION</a>
            </div>
            <div class="menu-item">
                <a href="index.html#about" onclick="closeMenu()" class="block text-3xl lg:text-6xl font-extralight mb-6 lg:mb-8 tracking-[0.3em] hover:text-white/70 transition-all">HISTOIRE</a>
            </div>
            <div class="menu-item">
                <a href="index.html#gallery" onclick="closeMenu()" class="block text-3xl lg:text-6xl font-extralight tracking-[0.3em] hover:text-white/70 transition-all">GALERIE</a>
            </div>
        </nav>
    </div>
</div>

<main class="pt-20">

<section class="py-16 lg:py-32">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="text-center mb-12 lg:mb-20">
            <h1 class="text-4xl lg:text-6xl font-extralight mb-6 lg:mb-8 tracking-wide">MEMBRE ANNUEL</h1>
            <div class="flex justify-center items-center gap-6 mb-8">
                <div class="w-16 h-px bg-white"></div>
                <div class="w-2 h-2 border border-white rotate-45"></div>
                <div class="w-16 h-px bg-white"></div>
            </div>
            <p class="text-lg text-white/70 max-w-2xl mx-auto leading-relaxed">
                Rejoignez notre communauté exclusive et profitez d'un accès complet aux événements privés, contenus exclusifs et services personnalisés.
            </p>
        </div>

        <div class="grid lg:grid-cols-5 gap-8 lg:gap-12">
            <div class="lg:col-span-2">
                <div class="price-highlight p-6 lg:p-8 mb-8">
                    <div class="text-xs tracking-[0.3em] text-white/60 mb-4">FORMULE STANDARD</div>
                    <h2 class="text-3xl lg:text-4xl font-extralight tracking-wide mb-6">MEMBRE ANNUEL</h2>
                    <div class="flex items-baseline gap-2 mb-6">
                        <span class="text-5xl lg:text-6xl font-extralight">2,500</span>
                        <span class="text-lg text-white/60">EUR</span>
                    </div>
                    <div class="space-y-4 text-sm text-white/70">
                        <div class="flex items-center gap-3">
                            <div class="w-1 h-1 bg-white"></div>
                            <span>Accès complet aux événements privés</span>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="w-1 h-1 bg-white"></div>
                            <span>Accès illimités aux clubs</span>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="w-1 h-1 bg-white"></div>
                            <span>x3 Accès SexRoom offert</span>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="w-1 h-1 bg-white"></div>
                            <span>x7 nuits offertes</span>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="w-1 h-1 bg-white"></div>
                            <span>Galerie photos & vidéos complète</span>
                        </div>
                    </div>
                </div>

                <div class="text-xs text-white/50 leading-relaxed">
                    * L'adhésion est valable pour une durée de 12 mois à compter de la validation du paiement. Renouvellement automatique sauf résiliation.
                </div>
                <div class="text-xs text-white/50 leading-relaxed">
                ** L'adhésion vous donnera accès aux adresses des clubs. Les "nuits offertes" et "accès au sexroom" peuvent vous etres restreint par nos employées si vous enfreignez le réglement. Divulger les adresses des clubs est interdit.
                </div>
            </div>

            <div class="lg:col-span-3">
                <div class="subscription-form">
                    <form id="subscriptionForm">
                        <div class="grid md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm tracking-[0.15em] mb-3">PRÉNOM *</label>
                                <input type="text" name="firstname" required placeholder="Votre prénom">
                            </div>
                            <div>
                                <label class="block text-sm tracking-[0.15em] mb-3">NOM *</label>
                                <input type="text" name="lastname" required placeholder="Votre nom">
                            </div>
                        </div>

                        <div class="mb-6">
                            <label class="block text-sm tracking-[0.15em] mb-3">EMAIL *</label>
                            <input type="email" name="email" required placeholder="votre@email.com">
                        </div>

                        <div class="grid md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm tracking-[0.15em] mb-3">TÉLÉPHONE *</label>
                                <input type="tel" name="phone" required placeholder="+33 6 XX XX XX XX">
                            </div>
                            <div>
                                <label class="block text-sm tracking-[0.15em] mb-3">ÂGE *</label>
                                <input type="number" name="age" min="18" required placeholder="18">
                            </div>
                        </div>

                        <div class="mb-6">
                            <label class="block text-sm tracking-[0.15em] mb-3">NATIONALITÉ *</label>
                            <select name="nationality" required>
                                <option value="">Sélectionnez votre nationalité</option>
                                <option value="française">Française</option>
                                <option value="belge">Belge</option>
                                <option value="suisse">Suisse</option>
                                <option value="canadienne">Canadienne</option>
                                <option value="américaine">Américaine</option>
                                <option value="anglaise">Anglaise</option>
                                <option value="allemande">Allemande</option>
                                <option value="espagnole">Espagnole</option>
                                <option value="italienne">Italienne</option>
                                <option value="autre">Autre</option>
                            </select>
                        </div>

                        <div class="mb-6">
                            <label class="block text-sm tracking-[0.15em] mb-3">COMMENT NOUS AVEZ-VOUS CONNU ? *</label>
                            <select name="referral" required>
                                <option value="">Sélectionnez une option</option>
                                <option value="ami">Recommandation d'un ami/membre</option>
                                <option value="internet">Recherche internet</option>
                                <option value="reseaux">Réseaux sociaux</option>
                                <option value="evenement">Événement privé</option>
                                <option value="autre">Autre</option>
                            </select>
                        </div>

                        <div class="mb-8">
                            <label class="block text-sm tracking-[0.15em] mb-3">MESSAGE PERSONNEL (OPTIONNEL)</label>
                            <textarea name="message" rows="4" placeholder="Parlez-nous de vos attentes, motivations ou questions..."></textarea>
                        </div>

                        <div class="space-y-4 mb-8">
                            <label class="checkbox-container text-sm">
                                <input type="checkbox" name="terms" required>
                                <span class="checkmark"></span>
                                J'accepte les conditions générales d'utilisation et la politique de confidentialité *
                            </label>
                            
                            <label class="checkbox-container text-sm">
                                <input type="checkbox" name="age_confirm" required>
                                <span class="checkmark"></span>
                                Je certifie avoir plus de 18 ans et être majeur dans mon pays de résidence *
                            </label>
                            
                            <label class="checkbox-container text-sm">
                                <input type="checkbox" name="newsletter">
                                <span class="checkmark"></span>
                                Je souhaite recevoir les actualités et invitations exclusives
                            </label>
                        </div>

                        <div class="border-t border-white/20 pt-8">
                            <div class="text-center">
                                <button type="submit" class="bg-white text-black px-12 py-4 text-sm font-medium tracking-[0.15em] hover:bg-white/90 transition-all duration-300 mb-4">
                                    FINALISER L'ADHÉSION - 2,500 EUR
                                </button>
                                <p class="text-xs text-white/50">
                                    Paiement sécurisé par carte bancaire. Vous serez redirigé vers notre plateforme de paiement.
                                </p>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

</main>

<footer class="border-t border-white/10 py-12 lg:py-16 px-4 lg:px-8 bg-black">
    <div class="max-w-6xl mx-auto">
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8 lg:gap-12 text-center md:text-left">
            <div class="md:col-span-2">
                <h4 class="text-3xl lg:text-4xl font-extralight mb-4 lg:mb-6 tracking-[0.3em]">HIZHAT</h4>
                <p class="text-white/60 leading-relaxed max-w-md mx-auto md:mx-0">Club privé porno depuis 2017. Crée avec du coeur et de la passion</p>
            </div>
            <div>
                <h5 class="font-medium mb-4 lg:mb-6 tracking-[0.15em]">CONTACT</h5>
                <p class="text-white/60 mb-2">contact@hizhat.com</p>
                <p class="text-white/60">+33 1 42 XX XX XX</p>
            </div>
            <div>
                <h5 class="font-medium mb-4 lg:mb-6 tracking-[0.15em]">LÉGAL</h5>
                <p class="text-white/60 mb-2">Mentions légales</p>
                <p class="text-white/60">Confidentialité</p>
            </div>
        </div>
        <div class="border-t border-white/10 mt-8 lg:mt-12 pt-6 lg:pt-8 flex flex-col md:flex-row justify-between items-center text-center md:text-left">
            <p class="text-white/50 text-sm tracking-wide mb-4 md:mb-0">&copy; 2025 HIZHAT</p>
            <p class="text-white/50 text-sm tracking-wide">TOUS DROITS RÉSERVÉS</p>
        </div>
    </div>
</footer>

<script>
let menuOpen = false;

function toggleMenu() {
    const hamburger = document.querySelector('.hamburger');
    const menu = document.querySelector('.fullscreen-menu');
    
    menuOpen = !menuOpen;
    hamburger.classList.toggle('open');
    menu.classList.toggle('open');
    
    if (menuOpen) {
        document.body.style.overflow = 'hidden';
    } else {
        document.body.style.overflow = 'auto';
    }
}

function closeMenu() {
    const hamburger = document.querySelector('.hamburger');
    const menu = document.querySelector('.fullscreen-menu');
    
    menuOpen = false;
    hamburger.classList.remove('open');
    menu.classList.remove('open');
    document.body.style.overflow = 'auto';
}

document.getElementById('subscriptionForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    if (!data.terms || !data.age_confirm) {
        alert('Vous devez accepter les conditions générales et certifier votre âge.');
        return;
    }
    
    alert('Formulaire soumis avec succès ! Vous allez être redirigé vers le paiement sécurisé.');
});

window.addEventListener('scroll', () => {
    document.querySelectorAll('.reveal').forEach(el => {
        const rect = el.getBoundingClientRect();
        if (rect.top < window.innerHeight - 100) {
            el.classList.add('show');
        }
    });
});
</script>

</body>
</html>