<?php
// Initialisation de l'application
require 'vendor/autoload.php';

// Utilisation des bibliothèques pour la découverte réseau
use GuzzleHttp\Client;

// Classe de découverte réseau
class NetworkDiscovery {
    private $localIP;
    private $devices = [];

    public function __construct() {
        // Obtenir l'IP locale
        $this->localIP = $this->getLocalIP();
    }

    // Obtenir l'adresse IP locale
    private function getLocalIP() {
        $ip = shell_exec("hostname -I | awk '{print $1}'");
        return trim($ip);
    }

    // Scanner le réseau pour trouver les appareils
    public function scanNetwork() {
        // Obtenir le préfixe réseau
        $ipParts = explode('.', $this->localIP);
        $networkPrefix = $ipParts[0] . '.' . $ipParts[1] . '.' . $ipParts[2] . '.';
        
        $devices = [];
        
        // Scanner les 254 adresses possibles (1-254)
        for ($i = 1; $i <= 254; $i++) {
            $ip = $networkPrefix . $i;
            
            // Utiliser ping pour vérifier si l'appareil est actif
            $pingResult = shell_exec("ping -c 1 -W 1 $ip | grep 'bytes from'");
            
            if (!empty($pingResult)) {
                // Appareil trouvé, obtenir plus d'informations
                $macAddress = $this->getMacAddress($ip);
                $hostname = $this->getHostname($ip);
                
                $devices[] = [
                    'ip' => $ip,
                    'mac' => $macAddress,
                    'hostname' => $hostname,
                    'status' => 'online'
                ];
            }
        }
        
        $this->devices = $devices;
        return $devices;
    }
    
    // Obtenir l'adresse MAC d'un appareil
    private function getMacAddress($ip) {
        // Utiliser arp pour obtenir l'adresse MAC
        $arpResult = shell_exec("arp -n $ip | grep -v Address | awk '{print $3}'");
        return trim($arpResult);
    }
    
    // Obtenir le nom d'hôte d'un appareil
    private function getHostname($ip) {
        $hostname = shell_exec("host $ip | awk '{print $5}'");
        return trim($hostname) ?: 'Unknown';
    }
    
    // Exécuter une commande ping
    public function pingDevice($ip, $count = 4) {
        return shell_exec("ping -c $count $ip");
    }
    
    // Exécuter une commande traceroute
    public function traceRoute($ip) {
        return shell_exec("traceroute $ip");
    }
    
    // Exécuter un scan nmap (basique)
    public function nmapScan($ip) {
        return shell_exec("nmap -sS $ip");
    }
    
    // Obtenir les appareils découverts
    public function getDevices() {
        return $this->devices;
    }
}

// Traitement des commandes
$network = new NetworkDiscovery();
$output = '';
$command = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['command'])) {
        $command = $_POST['command'];
        $args = explode(' ', $command);
        
        switch ($args[0]) {
            case 'scan':
                $devices = $network->scanNetwork();
                $output = "Scan terminé. " . count($devices) . " appareils trouvés.\n\n";
                foreach ($devices as $device) {
                    $output .= "IP: " . $device['ip'] . "\n";
                    $output .= "MAC: " . $device['mac'] . "\n";
                    $output .= "Hostname: " . $device['hostname'] . "\n";
                    $output .= "Status: " . $device['status'] . "\n\n";
                }
                break;
                
            case 'ping':
                if (isset($args[1])) {
                    $output = $network->pingDevice($args[1]);
                } else {
                    $output = "Erreur: Spécifiez une adresse IP à ping.";
                }
                break;
                
            case 'traceroute':
                if (isset($args[1])) {
                    $output = $network->traceRoute($args[1]);
                } else {
                    $output = "Erreur: Spécifiez une adresse IP pour traceroute.";
                }
                break;
                
            case 'nmap':
                if (isset($args[1])) {
                    $output = $network->nmapScan($args[1]);
                } else {
                    $output = "Erreur: Spécifiez une adresse IP pour nmap.";
                }
                break;
                
            case 'help':
                $output = "Commandes disponibles:\n";
                $output .= "scan - Scanner le réseau pour les appareils\n";
                $output .= "ping [ip] - Envoyer des paquets ping à l'adresse IP\n";
                $output .= "traceroute [ip] - Tracer la route vers l'adresse IP\n";
                $output .= "nmap [ip] - Scanner les ports ouverts sur l'adresse IP\n";
                $output .= "help - Afficher cette aide\n";
                $output .= "clear - Effacer l'écran\n";
                break;
                
            case 'clear':
                $output = '';
                break;
                
            default:
                $output = "Commande non reconnue. Tapez 'help' pour voir les commandes disponibles.";
                break;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terminal Réseau</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0; }
        }
        .cursor {
            animation: blink 1s step-end infinite;
        }
    </style>
</head>
<body class="bg-black text-green-500 font-mono p-4">
    <div class="container mx-auto max-w-4xl">
        <div class="flex items-center mb-4">
            <h1 class="text-xl font-bold">Terminal Réseau</h1>
            <div class="ml-auto flex space-x-2">
                <button id="minimizeBtn" class="bg-yellow-500 rounded-full w-3 h-3"></button>
                <button id="maximizeBtn" class="bg-green-600 rounded-full w-3 h-3"></button>
                <button id="closeBtn" class="bg-red-500 rounded-full w-3 h-3"></button>
            </div>
        </div>
        
        <div class="bg-gray-900 rounded-md p-4 h-96 overflow-y-auto mb-4" id="terminal-output">
            <pre class="whitespace-pre-wrap"><?php echo $output; ?></pre>
        </div>
        
        <form method="post" class="flex">
            <div class="flex-grow flex items-center">
                <span class="mr-2">root@network:~$</span>
                <input type="text" name="command" id="command-input" value="<?php echo htmlspecialchars($command); ?>" 
                       class="bg-transparent focus:outline-none flex-grow" 
                       autocomplete="off" autofocus placeholder="Tapez 'help' pour voir les commandes">
                <span class="cursor">|</span>
            </div>
            <button type="submit" class="hidden">Exécuter</button>
        </form>
        
        <div class="mt-4 text-xs text-gray-500">
            <p>Commandes suggérées: scan, ping 192.168.1.1, traceroute 8.8.8.8, nmap 192.168.1.1</p>
        </div>
    </div>
    
    <script>
        // Focus sur l'input quand on clique n'importe où dans le terminal
        document.addEventListener('click', function() {
            document.getElementById('command-input').focus();
        });
        
        // Remonter automatiquement en bas du terminal quand il y a un nouveau résultat
        window.onload = function() {
            var terminalOutput = document.getElementById('terminal-output');
            terminalOutput.scrollTop = terminalOutput.scrollHeight;
        };
    </script>
</body>
</html>