<?php
session_start();

if (!isset($_SESSION['registration_data'])) {
    header('Location: index.php');
    exit;
}

$data = $_SESSION['registration_data'];
$nom_complet = $data['prenom'] . ' ' . $data['nom'];
$error_message = isset($_GET['error']) ? $_GET['error'] : '';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paiement Annulé - A Sixteen Dream</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-black text-white">
    <div class="px-8 py-16 max-w-3xl mx-auto text-center">
        <div class="w-16 h-16 bg-orange-500 rounded-full flex items-center justify-center mx-auto mb-8">
            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.996-.833-2.768 0L4.064 19.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
        </div>
        
        <h1 class="text-4xl font-light mb-6" style="font-weight: 100;">Paiement Annulé</h1>
        
        <?php if ($error_message === 'stripe_error'): ?>
            <p class="text-xl opacity-90 mb-8 font-light">
                Oups <strong><?php echo htmlspecialchars($nom_complet); ?></strong> ! 
                Une erreur technique s'est produite lors du paiement.
            </p>
        <?php else: ?>
            <p class="text-xl opacity-90 mb-8 font-light">
                Salut <strong><?php echo htmlspecialchars($nom_complet); ?></strong> ! 
                Le paiement a été annulé, mais ton inscription reste valide.
            </p>
        <?php endif; ?>
        
        <div class="bg-gray-900 rounded-lg p-6 mb-8 text-left">
            <h3 class="text-xl font-light mb-4 text-center" style="font-weight: 300;">Ton inscription est confirmée ✓</h3>
            <div class="space-y-2 text-sm font-light">
                <p><strong>Nom :</strong> <?php echo htmlspecialchars($data['nom']); ?></p>
                <p><strong>Prénom :</strong> <?php echo htmlspecialchars($data['prenom']); ?></p>
                <p><strong>Email :</strong> <?php echo htmlspecialchars($data['email']); ?></p>
                
                <?php if ($data['enfant'] && !empty($data['nombre_enfants'])): ?>
                    <p><strong>Enfants :</strong> <?php echo htmlspecialchars($data['nombre_enfants']); ?> enfant(s)</p>
                <?php endif; ?>
                
                <?php if ($data['conjoint'] && !empty($data['prenom_conjoint'])): ?>
                    <p><strong>Accompagnant :</strong> <?php echo htmlspecialchars($data['prenom_conjoint'] . ' ' . $data['nom_conjoint']); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="bg-gray-800 rounded-lg p-6 mb-8">
            <h4 class="font-light mb-2 text-lg">🎉 A Sixteen Dream</h4>
            <p class="opacity-75 text-sm font-light">
                <strong>Vendredi 20 Mars 2025</strong> • 18h30 - 02h00<br>
                Château de la Hulpe - Chaussée de Bruxelles 111, 1310 La Hulpe
            </p>
        </div>
        
        <p class="opacity-75 mb-8 text-sm font-light">
            Tu pourras offrir ton cadeau à Izhak directement sur place le jour de la fête !
        </p>
        
        <div class="space-y-4">
            <?php if ($error_message !== 'stripe_error'): ?>
                <div class="flex flex-col sm:flex-row gap-4 justify-center mb-4">
                    <a href="checkout.php" class="bg-green-600 text-white font-light py-3 px-8 hover:bg-green-700 transition-colors text-xs tracking-wider">
                        REPRENDRE LE PAIEMENT
                    </a>
                    <a href="success.php" class="bg-white text-black font-light py-3 px-8 hover:bg-gray-200 transition-colors text-xs tracking-wider">
                        CONTINUER SANS PAYER
                    </a>
                </div>
            <?php else: ?>
                <a href="success.php" class="bg-white text-black font-light py-3 px-8 inline-block hover:bg-gray-200 transition-colors mb-4 text-xs tracking-wider">
                    CONTINUER SANS PAYER
                </a>
            <?php endif; ?>
            
            <div>
                <a href="index.php" class="text-white opacity-50 hover:opacity-100 text-sm font-light">
                    ← Retour à l'accueil
                </a>
            </div>
        </div>
    </div>
</body>
</html>