<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>A Sixteen Dream</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .fade-in {
            opacity: 0;
            animation: fadeIn 1.2s ease forwards;
        }
        @keyframes fadeIn {
            to {
                opacity: 1;
            }
        }
        .delay-1 { animation-delay: 0.3s; }
        .delay-2 { animation-delay: 0.6s; }
        .delay-3 { animation-delay: 0.9s; }
        .delay-4 { animation-delay: 1.2s; }
        .gradient-bottom {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 400px;
            pointer-events: none;
            z-index: 0;
        }
        .gradient-layer {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 100%;
            transition: opacity 1.5s ease;
        }
        input, select, textarea {
            font-size: 16px !important;
        }
    </style>
</head>
<body class="bg-black text-white relative">
    <div class="gradient-bottom">
        <div class="gradient-layer" id="gradient1"></div>
        <div class="gradient-layer" id="gradient2" style="opacity: 0;"></div>
    </div>
    
    <div class="px-6 py-12 md:py-16 max-w-4xl mx-auto relative z-10">
        <div class="mb-12 md:mb-20">
            <h1 class="text-5xl md:text-8xl font-extralight mb-6 fade-in" style="font-weight: 100;">A sixteen dream</h1>
            
            <p class="text-sm opacity-50 mb-10 md:mb-12 font-light max-w-md fade-in delay-1">
                Une soirée d'exception pour célébrer les 16 ans d'Izhak dans un lieu magnifique amménager et séléctionner par ses soins.
            </p>

            <div class="text-xs opacity-40 font-light space-y-1 mb-10 md:mb-12 fade-in delay-1">
                <p>Vendredi 20 Mars 2025</p>
                <p>18h30 - 02h00</p>
                <p>Château de la Hulpe - Chaussée de Bruxelles 111, 1310 La Hulpe</p>
            </div>

            <p class="text-xs opacity-30 font-light fade-in delay-1">Présenté par Imators</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-10 mb-12 md:mb-16 fade-in delay-2">
            <div>
                <div class="w-10 h-10 mb-3 flex items-center justify-center opacity-60">
                    <svg class="w-full h-full" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                </div>
                <h3 class="text-sm font-light mb-2 opacity-80">Cinq univers</h3>
                <p class="text-xs opacity-40 font-light">Plus de cinq salles thématiques avec différentes activités</p>
            </div>

            <div>
                <div class="w-10 h-10 mb-3 flex items-center justify-center opacity-60">
                    <svg class="w-full h-full" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                    </svg>
                </div>
                <h3 class="text-sm font-light mb-2 opacity-80">Feu d'artifice</h3>
                <p class="text-xs opacity-40 font-light">Un spectacle pyrotechnique à couper le souffle illuminera la nuit</p>
            </div>

            <div>
                <div class="w-10 h-10 mb-3 flex items-center justify-center opacity-60">
                    <svg class="w-full h-full" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"/>
                    </svg>
                </div>
                <h3 class="text-sm font-light mb-2 opacity-80">DJ professionnel</h3>
                <p class="text-xs opacity-40 font-light">Un DJ accompagnera la soirée avec une ambiance musicale inoubliable</p>
            </div>
        </div>

        <div class="max-w-lg fade-in delay-3">
            <form method="POST" action="process.php" class="space-y-4 md:space-y-5">
                <div class="space-y-4 md:space-y-5">
                    <input type="text" name="nom" placeholder="Nom" required class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors font-light w-full placeholder-gray-700" style="font-size: 16px;">
                    <input type="text" name="prenom" placeholder="Prénom" required class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors font-light w-full placeholder-gray-700" style="font-size: 16px;">
                    <input type="tel" name="telephone" placeholder="Téléphone" required class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors font-light w-full placeholder-gray-700" style="font-size: 16px;">
                    <input type="email" name="email" placeholder="Email" required class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors font-light w-full placeholder-gray-700" style="font-size: 16px;">
                </div>

                <div class="pt-3">
                    <label class="flex items-center space-x-3 cursor-pointer opacity-60 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="enfant" name="enfant" onclick="toggleEnfantSection()" class="w-3 h-3">
                        <span class="font-light text-xs">Avez-vous des enfants ?</span>
                    </label>
                    
                    <div id="enfant-section" class="hidden mt-4 ml-6 space-y-4">
                        <select name="nombre_enfants" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light" style="font-size: 16px;">
                            <option value="" class="bg-black">Nombre d'enfants</option>
                            <option value="1" class="bg-black">1</option>
                            <option value="2" class="bg-black">2</option>
                            <option value="3" class="bg-black">3</option>
                            <option value="4" class="bg-black">4</option>
                            <option value="5" class="bg-black">5+</option>
                        </select>
                        <input type="text" name="nom_enfants" placeholder="Nom de famille des enfants" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light placeholder-gray-700" style="font-size: 16px;">
                    </div>
                </div>

                <div>
                    <label class="flex items-center space-x-3 cursor-pointer opacity-60 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="conjoint" name="conjoint" onclick="toggleConjointSection()" class="w-3 h-3">
                        <span class="font-light text-xs">Avez-vous un conjoint ?</span>
                    </label>
                    
                    <div id="conjoint-section" class="hidden mt-4 ml-6 space-y-4">
                        <input type="text" name="nom_conjoint" placeholder="Nom du conjoint" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light placeholder-gray-700" style="font-size: 16px;">
                        <input type="text" name="prenom_conjoint" placeholder="Prénom du conjoint" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light placeholder-gray-700" style="font-size: 16px;">
                    </div>
                </div>

                <div>
                    <label class="flex items-center space-x-3 cursor-pointer opacity-60 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="parking" name="parking" onclick="toggleParkingSection()" class="w-3 h-3">
                        <span class="font-light text-xs">Besoin d'une place de parking ?</span>
                    </label>
                    
                    <div id="parking-section" class="hidden mt-4 ml-6 space-y-3">
                        <p class="text-xs opacity-30 font-light">Place réservée et attribuée sur place</p>
                        <select name="type_vehicule" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light" style="font-size: 16px;">
                            <option value="" class="bg-black">Type de véhicule</option>
                            <option value="voiture" class="bg-black">Voiture</option>
                            <option value="moto" class="bg-black">Moto</option>
                            <option value="camion" class="bg-black">Camion</option>
                            <option value="velo" class="bg-black">Vélo</option>
                        </select>
                    </div>
                </div>

                <div>
                    <label class="block mb-2 font-light text-xs opacity-60">Préférences alimentaires</label>
                    <p class="text-xs opacity-30 mb-3 font-light">Viande halal servie sur place</p>
                    <select name="preferences_alimentaires" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full font-light" style="font-size: 16px;">
                        <option value="" class="bg-black">Aucune préférence</option>
                        <option value="vegetarien" class="bg-black">Végétarien</option>
                        <option value="pescitarien" class="bg-black">Pescitarien</option>
                        <option value="vegan" class="bg-black">Vegan</option>
                        <option value="sans_gluten" class="bg-black">Sans gluten</option>
                        <option value="halal_strict" class="bg-black">Halal uniquement</option>
                        <option value="autre" class="bg-black">Autre</option>
                    </select>
                </div>

                <div>
                    <label class="flex items-center space-x-3 cursor-pointer opacity-60 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="cadeau" name="cadeau" onclick="toggleCadeauSection()" class="w-3 h-3">
                        <span class="font-light text-xs">Offrir un cadeau à Izhak en ligne ?</span>
                    </label>
                    
                    <div id="cadeau-section" class="hidden mt-4 ml-6 space-y-3">
                        <p class="text-xs opacity-30 mb-3 font-light">Choisis le montant de ton cadeau</p>
                        <div class="grid grid-cols-3 gap-2 mb-2">
                            <label class="flex items-center justify-center border border-gray-900 py-2 cursor-pointer hover:border-gray-600 transition-colors font-light text-xs">
                                <input type="radio" name="montant_cadeau" value="10" class="sr-only">
                                <span>10€</span>
                            </label>
                            <label class="flex items-center justify-center border border-gray-900 py-2 cursor-pointer hover:border-gray-600 transition-colors font-light text-xs">
                                <input type="radio" name="montant_cadeau" value="25" class="sr-only">
                                <span>25€</span>
                            </label>
                            <label class="flex items-center justify-center border border-gray-900 py-2 cursor-pointer hover:border-gray-600 transition-colors font-light text-xs">
                                <input type="radio" name="montant_cadeau" value="50" class="sr-only">
                                <span>50€</span>
                            </label>
                        </div>
                        <div class="grid grid-cols-2 gap-2">
                            <label class="flex items-center justify-center border border-gray-900 py-2 cursor-pointer hover:border-gray-600 transition-colors font-light text-xs">
                                <input type="radio" name="montant_cadeau" value="100" class="sr-only">
                                <span>100€</span>
                            </label>
                            <label class="flex items-center justify-center border border-gray-900 py-2 cursor-pointer hover:border-gray-600 transition-colors font-light text-xs">
                                <input type="radio" name="montant_cadeau" value="autre" class="sr-only">
                                <span>Autre</span>
                            </label>
                        </div>
                        <input type="number" name="montant_personnalise" placeholder="Montant personnalisé (€)" min="1" class="bg-transparent border-b border-gray-900 px-0 py-2 text-white focus:outline-none focus:border-gray-600 transition-colors w-full hidden font-light placeholder-gray-700" id="montant-personnalise" style="font-size: 16px;">
                    </div>
                </div>

                <div class="pt-4 space-y-2">
                    <label class="flex items-start space-x-3 cursor-pointer opacity-40 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="promo" name="promo" class="w-3 h-3 mt-0.5">
                        <span class="font-light text-xs">J'accepte les promotions d'Aktascorp</span>
                    </label>
                    
                    <label class="flex items-start space-x-3 cursor-pointer opacity-60 hover:opacity-100 transition-opacity">
                        <input type="checkbox" id="donnees" name="donnees" required class="w-3 h-3 mt-0.5">
                        <span class="font-light text-xs">J'accepte le stockage de mes données pour vérification</span>
                    </label>
                </div>

                <button type="submit" class="bg-white text-black font-light py-3 w-full hover:bg-gray-200 transition-colors mt-8 text-xs tracking-wider">
                    CONFIRMER MA PRÉSENCE
                </button>
            </form>
        </div>
    </div>

    <script>
        function toggleEnfantSection() {
            document.getElementById('enfant-section').classList.toggle('hidden', !document.getElementById('enfant').checked);
        }

        function toggleConjointSection() {
            document.getElementById('conjoint-section').classList.toggle('hidden', !document.getElementById('conjoint').checked);
        }

        function toggleParkingSection() {
            document.getElementById('parking-section').classList.toggle('hidden', !document.getElementById('parking').checked);
        }

        function toggleCadeauSection() {
            document.getElementById('cadeau-section').classList.toggle('hidden', !document.getElementById('cadeau').checked);
        }

        document.querySelectorAll('input[name="montant_cadeau"]').forEach(function(radio) {
            radio.addEventListener('change', function() {
                document.getElementById('montant-personnalise').classList.toggle('hidden', this.value !== 'autre');
                
                this.closest('label').parentElement.querySelectorAll('label').forEach(function(label) {
                    label.classList.remove('bg-white', 'text-black', 'border-white');
                    label.classList.add('border-gray-900');
                });
                this.closest('label').classList.remove('border-gray-900');
                this.closest('label').classList.add('bg-white', 'text-black', 'border-white');
            });
        });

        const gradients = [
            'linear-gradient(to top, rgba(25, 50, 80, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(70, 30, 90, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(80, 25, 25, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(90, 80, 20, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(20, 60, 40, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(70, 75, 85, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(90, 65, 45, 0.6) 0%, transparent 100%)',
            'linear-gradient(to top, rgba(80, 75, 65, 0.6) 0%, transparent 100%)'
        ];

        let currentIndex = 0;
        let isFirstLayer = true;
        
        const gradient1 = document.getElementById('gradient1');
        const gradient2 = document.getElementById('gradient2');
        
        gradient1.style.background = gradients[0];
        
        setInterval(() => {
            currentIndex = (currentIndex + 1) % gradients.length;
            
            if (isFirstLayer) {
                gradient2.style.background = gradients[currentIndex];
                gradient2.style.opacity = '1';
                gradient1.style.opacity = '0';
            } else {
                gradient1.style.background = gradients[currentIndex];
                gradient1.style.opacity = '1';
                gradient2.style.opacity = '0';
            }
            
            isFirstLayer = !isFirstLayer;
        }, 1500);
    </script>
</body>
</html>