<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Project Estimator</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #000000;
            color: #ffffff;
        }

        .card {
            background-color: #111111;
            border: 1px solid #222222;
            border-radius: 4px;
            transition: all 0.2s ease;
        }

        .card:hover {
            border-color: #333333;
        }

        .card.selected {
            border-color: #ffffff;
            background-color: #1a1a1a;
        }

        .price {
            position: relative;
            display: inline-flex;
            align-items: center;
        }

        .price::before {
            content: "";
            margin-right: 4px;
        }

        input[type="checkbox"] {
            appearance: none;
            width: 20px;
            height: 20px;
            border: 1px solid #333333;
            border-radius: 4px;
            background-color: #111111;
            cursor: pointer;
            position: relative;
        }

        input[type="checkbox"]:checked {
            background-color: #ffffff;
        }

        input[type="checkbox"]:checked::after {
            content: "?";
            position: absolute;
            color: #000000;
            font-size: 14px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .progress-bar {
            height: 1px;
            background: #222222;
            overflow: hidden;
        }

        .progress {
            height: 100%;
            background: #ffffff;
            transition: width 0.3s ease;
        }

        input[type="text"],
        input[type="email"],
        textarea {
            background-color: #111111;
            border: 1px solid #333333;
            color: #ffffff;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        textarea:focus {
            border-color: #ffffff;
            outline: none;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="fixed top-0 w-full bg-black border-b border-[#222222] z-50">
        <div class="max-w-5xl mx-auto px-6 py-4">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <span class="font-medium">Project Estimator</span>
                    <span class="text-[#666666]">Step <span id="currentStep">1</span> of 3</span>
                </div>
                
                <div class="w-32">
                    <div class="progress-bar">
                        <div id="progressBar" class="progress" style="width: 33%"></div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="max-w-5xl mx-auto px-6 pt-24 pb-12">
        <div id="steps">
            <!-- Step 1: Project Type -->
            <div class="step active" data-step="1">
                <div class="max-w-2xl mx-auto">
                    <div class="mb-12">
                        <h1 class="text-2xl font-medium mb-3">Choose Project Type</h1>
                        <p class="text-[#999999]">Select the package that matches your needs</p>
                    </div>

                    <div class="space-y-4">
                        <!-- Basic Website -->
                        <div onclick="selectProject('basic', 499)" class="card p-6 cursor-pointer">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h3 class="text-lg font-medium mb-2">Basic Website</h3>
                                    <p class="text-[#999999] text-sm mb-4">Simple professional website</p>
                                    <ul class="space-y-2 text-sm text-[#999999]">
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Up to 5 pages
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Contact form
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Mobile responsive
                                        </li>
                                    </ul>
                                </div>
                                <div class="price text-xl font-medium">499</div>
                            </div>
                        </div>

                        <!-- Business Website -->
                        <div onclick="selectProject('business', 999)" class="card p-6 cursor-pointer">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h3 class="text-lg font-medium mb-2">Business Website</h3>
                                    <p class="text-[#999999] text-sm mb-4">Complete business solution</p>
                                    <ul class="space-y-2 text-sm text-[#999999]">
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Up to 10 pages
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Content Management
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Blog functionality
                                        </li>
                                    </ul>
                                </div>
                                <div class="price text-xl font-medium">999</div>
                            </div>
                        </div>

                        <!-- E-commerce -->
                        <div onclick="selectProject('ecommerce', 1499)" class="card p-6 cursor-pointer">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h3 class="text-lg font-medium mb-2">E-commerce Website</h3>
                                    <p class="text-[#999999] text-sm mb-4">Full online store setup</p>
                                    <ul class="space-y-2 text-sm text-[#999999]">
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Product management
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Payment integration
                                        </li>
                                        <li class="flex items-center">
                                            <svg class="w-4 h-4 mr-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Inventory system
                                        </li>
                                    </ul>
                                </div>
                                <div class="price text-xl font-medium">1499</div>
                            </div>
                        </div>
                    </div>

                    <!-- Continue Button -->
                    <button onclick="nextStep(1)" class="w-full bg-white text-black px-6 py-3 mt-8 hover:bg-[#eeeeee] transition-colors">
                        Continue
                    </button>
                </div>
            </div>

<!-- Step 2: Features -->
            <div class="step hidden" data-step="2">
                <div class="max-w-2xl mx-auto">
                    <div class="mb-12">
                        <h1 class="text-2xl font-medium mb-3">Additional Features</h1>
                        <p class="text-[#999999]">Customize your project with extra features</p>
                    </div>

                    <div class="space-y-4">
                        <!-- Contact Form -->
                        <label class="card p-6 flex items-center justify-between cursor-pointer">
                            <div>
                                <h3 class="text-lg font-medium mb-1">Advanced Contact System</h3>
                                <p class="text-[#999999] text-sm">Form with file uploads and notifications</p>
                            </div>
                            <div class="flex items-center gap-6">
                                <div class="price text-lg font-medium">99</div>
                                <input type="checkbox" value="99" onchange="updateFeatures()">
                            </div>
                        </label>

                        <!-- Analytics -->
                        <label class="card p-6 flex items-center justify-between cursor-pointer">
                            <div>
                                <h3 class="text-lg font-medium mb-1">Analytics Package</h3>
                                <p class="text-[#999999] text-sm">Visitor tracking and reporting</p>
                            </div>
                            <div class="flex items-center gap-6">
                                <div class="price text-lg font-medium">149</div>
                                <input type="checkbox" value="149" onchange="updateFeatures()">
                            </div>
                        </label>

                        <!-- SEO Package -->
                        <label class="card p-6 flex items-center justify-between cursor-pointer">
                            <div>
                                <h3 class="text-lg font-medium mb-1">SEO Setup</h3>
                                <p class="text-[#999999] text-sm">Search engine optimization basics</p>
                            </div>
                            <div class="flex items-center gap-6">
                                <div class="price text-lg font-medium">199</div>
                                <input type="checkbox" value="199" onchange="updateFeatures()">
                            </div>
                        </label>

                        <!-- Multilingual -->
                        <label class="card p-6 flex items-center justify-between cursor-pointer">
                            <div>
                                <h3 class="text-lg font-medium mb-1">Multilingual Support</h3>
                                <p class="text-[#999999] text-sm">Additional language versions</p>
                            </div>
                            <div class="flex items-center gap-6">
                                <div class="price text-lg font-medium">299</div>
                                <input type="checkbox" value="299" onchange="updateFeatures()">
                            </div>
                        </label>
                    </div>

                    <!-- Navigation -->
                    <div class="flex gap-4 mt-8">
                        <button onclick="prevStep(2)" class="flex-1 border border-[#333333] px-6 py-3 hover:border-[#444444] transition-colors">
                            Back
                        </button>
                        <button onclick="nextStep(2)" class="flex-1 bg-white text-black px-6 py-3 hover:bg-[#eeeeee] transition-colors">
                            Continue
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 3: Summary -->
            <div class="step hidden" data-step="3">
                <div class="max-w-2xl mx-auto">
                    <div class="mb-12">
                        <h1 class="text-2xl font-medium mb-3">Project Summary</h1>
                        <p class="text-[#999999]">Review your selections and submit request</p>
                    </div>

                    <div class="card p-8 mb-8">
                        <!-- Total Price -->
                        <div class="text-center mb-12">
                            <p class="text-[#999999] text-sm mb-2">Total Investment</p>
                            <div class="price text-4xl font-medium" id="totalAmount">0</div>
                        </div>

                        <!-- Price Breakdown -->
                        <div class="space-y-4">
                            <div class="flex justify-between py-3 border-b border-[#222222]">
                                <span class="text-[#999999]">Base Package</span>
                                <div class="price font-medium" id="basePrice">0</div>
                            </div>
                            
                            <div class="flex justify-between py-3 border-b border-[#222222]">
                                <span class="text-[#999999]">Additional Features</span>
                                <div class="price font-medium" id="featuresPrice">0</div>
                            </div>
                        </div>

                        <!-- Timeline -->
                        <div class="mt-8 p-4 bg-[#111111] border border-[#222222]">
                            <p class="text-[#999999] text-sm">Estimated delivery: <span id="deliveryTime" class="text-white">2-3 weeks</span></p>
                        </div>
                    </div>

                    <!-- Contact Form -->
                    <div class="card p-8">
                        <h2 class="text-xl font-medium mb-6">Submit Request</h2>
                        <form onsubmit="submitForm(event)" class="space-y-6">
                            <div class="space-y-2">
                                <label class="text-sm">Name</label>
                                <input type="text" required class="w-full px-4 py-2">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm">Email</label>
                                <input type="email" required class="w-full px-4 py-2">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm">Message</label>
                                <textarea required class="w-full px-4 py-2 h-24"></textarea>
                            </div>

                            <div class="flex gap-4">
                                <button type="button" onclick="resetEstimate()" class="flex-1 border border-[#333333] px-6 py-3 hover:border-[#444444] transition-colors">
                                    Start Over
                                </button>
                                <button type="submit" class="flex-1 bg-white text-black px-6 py-3 hover:bg-[#eeeeee] transition-colors">
                                    Submit
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        let currentStep = 1;
        let basePrice = 0;
        let featuresPrice = 0;
        let selectedProjectType = '';

        function updateProgress(step) {
            const progress = (step / 3) * 100;
            document.getElementById('progressBar').style.width = `${progress}%`;
            document.getElementById('currentStep').textContent = step;
        }

        function selectProject(type, price) {
            basePrice = price;
            selectedProjectType = type;
            
            document.querySelectorAll('.card').forEach(card => {
                card.classList.remove('selected');
            });
            event.currentTarget.classList.add('selected');
            
            updateTotal();

            const deliveryTimes = {
                basic: '2-3 weeks',
                business: '3-4 weeks',
                ecommerce: '4-5 weeks'
            };
            document.getElementById('deliveryTime').textContent = deliveryTimes[type];
        }

        function updateFeatures() {
            featuresPrice = Array.from(document.querySelectorAll('input[type="checkbox"]:checked'))
                .reduce((sum, checkbox) => sum + parseInt(checkbox.value), 0);
            updateTotal();
        }

        function updateTotal() {
            const total = basePrice + featuresPrice;
            document.getElementById('totalAmount').textContent = total;
            document.getElementById('basePrice').textContent = basePrice;
            document.getElementById('featuresPrice').textContent = featuresPrice;
        }

        function nextStep(currentStepNum) {
            if (currentStepNum === 1 && basePrice === 0) {
                alert('Please select a project type to continue.');
                return;
            }

            const currentDiv = document.querySelector(`[data-step="${currentStepNum}"]`);
            const nextDiv = document.querySelector(`[data-step="${currentStepNum + 1}"]`);
            
            currentDiv.classList.add('hidden');
            nextDiv.classList.remove('hidden');
            
            updateProgress(currentStepNum + 1);
            window.scrollTo(0, 0);
        }

        function prevStep(currentStepNum) {
            const currentDiv = document.querySelector(`[data-step="${currentStepNum}"]`);
            const prevDiv = document.querySelector(`[data-step="${currentStepNum - 1}"]`);
            
            currentDiv.classList.add('hidden');
            prevDiv.classList.remove('hidden');
            
            updateProgress(currentStepNum - 1);
            window.scrollTo(0, 0);
        }

        function resetEstimate() {
            basePrice = 0;
            featuresPrice = 0;
            selectedProjectType = '';
            
            document.getElementById('totalAmount').textContent = '0';
            document.getElementById('basePrice').textContent = '0';
            document.getElementById('featuresPrice').textContent = '0';
            
            document.querySelectorAll('input[type="checkbox"]').forEach(checkbox => {
                checkbox.checked = false;
            });
            
            document.querySelectorAll('.card').forEach(card => {
                card.classList.remove('selected');
            });
            
            document.querySelectorAll('.step').forEach(step => {
                step.classList.add('hidden');
            });
            document.querySelector('[data-step="1"]').classList.remove('hidden');
            
            updateProgress(1);
            window.scrollTo(0, 0);
        }

        function submitForm(event) {
            event.preventDefault();
            alert('Request submitted successfully. We will contact you soon.');
            resetEstimate();
        }

        updateProgress(1);
    </script>
</body>
</html>