<?php
$documentData = json_decode(file_get_contents('document.json'), true);
$isSigned = isset($documentData['signed']) && $documentData['signed'] === true;

if ($_POST['action'] === 'sign') {
    $documentData['signed'] = true;
    file_put_contents('document.json', json_encode($documentData, JSON_PRETTY_PRINT));
    echo json_encode(['success' => true]);
    exit;
}
?>

<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document à signer</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; font-weight: 300; }
    </style>
</head>
<body class="bg-black text-white min-h-screen">

<div id="loading-modal" class="fixed inset-0 bg-black bg-opacity-95 flex items-center justify-center z-50">
    <div class="text-center">
        <img src="https://cdn.imators.com/logo.png" alt="Logo" class="w-24 h-24 mx-auto mb-6 animate-pulse">
        <div class="text-xl text-gray-300">Vérification du document...</div>
    </div>
</div>

<?php if (!$isSigned): ?>

<div id="main-content" class="hidden container mx-auto px-6 py-12 max-w-4xl">
    <h1 class="text-4xl font-light mb-8 text-center">Accord de remise en ligne d'Instagram</h1>

<div class="bg-gray-900 rounded-lg p-8 mb-8">
    <p class="text-lg leading-relaxed mb-6">
        Ce document présente un dossier mis en suspend du au doute familial et a l'inquiétude de la ressuite de l'annee de Izhak. Aujourd'hui il refait surface pour mettre un terme a cette question dans quand reviendra Instagram.
    </p>
    
    <p class="text-lg leading-relaxed mb-6">
        A l'occasion des vacances d'été,  moi Izhak trouverai cela chouette de permettre la réouverture d'Instagram. Le réseau utilisé selon Mme. Bouaissa de manière "incorrecte" sera désormais sous plusieurs conditions, utilisées de manière naturelle et normal par Izhak.
    </p>
    
    <p class="text-lg leading-relaxed mb-6">
        La demande ne concerne que le désir d'être à jour sur le monde, de pouvoir être à jour avec des amis (parce qu'Instagram a tendance à être avec Whatsapp les moteurs de la conversation en ligne) et de pouvoir simplement partager ses créations.
    </p>
    
    <p class="text-lg leading-relaxed">
        Ce document fait foi et engage les parties signataires dans le cadre de cet accord de remise en ligne.
    </p>
</div>

<div class="border-t border-gray-700 pt-8">
    <h2 class="text-2xl font-light mb-6">Signature requise</h2>
    <p class="text-gray-300 mb-4">
        Pour valider ce document, veuillez saisir exactement le texte suivant à la lettre prêt, majuscule, virgule comprise :
    </p>
    <p class="text-yellow-400 mb-6 italic">
        "Moi, Samia Bouaissa, confirme avoir lu ce document en entier et avoir pris connaissance de chaque point et d'accorder la remise en ligne d'Instagram pour Izhak"
    </p>
    
    <textarea 
        id="signature-text" 
        class="w-full h-32 bg-gray-800 border border-gray-600 rounded-lg p-4 text-white resize-none focus:outline-none focus:border-yellow-400"
        placeholder="Saisissez votre confirmation ici...">
    </textarea>
    
    <button 
        id="validate-btn" 
        class="mt-6 bg-yellow-500 hover:bg-yellow-600 text-black px-8 py-3 rounded-lg font-medium transition-colors"
        onclick="validateSignature()">
        Valider la signature
    </button>
</div>

</div>
<?php endif; ?>

<div id="success-modal" class="<?php echo $isSigned ? '' : 'hidden'; ?> fixed inset-0 bg-black bg-opacity-95 flex items-center justify-center z-50">
    <div class="text-center">
        <div class="text-6xl mb-6">✓</div>
        <h2 class="text-4xl font-light mb-4 text-green-400">Document signé avec succès</h2>
        <p class="text-xl text-gray-300">
            La signature a été validée. Le document n'est plus accessible.
        </p>
    </div>
</div>

<script>
    window.onload = function() {
        setTimeout(function() {
            document.getElementById('loading-modal').style.display = 'none';
            <?php if (!$isSigned): ?>
            document.getElementById('main-content').classList.remove('hidden');
            <?php endif; ?>
        }, 2000);
    };

    <?php if (!$isSigned): ?>
    function validateSignature() {
        const textarea = document.getElementById('signature-text');
        const expectedText = 'Moi, Samia Bouaissa, confirme avoir lu ce document en entier et avoir pris connaissance de chaque point et d\'accorder la remise en ligne d\'Instagram pour Izhak';
        
        if (textarea.value.trim() === expectedText) {
            fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'action=sign'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('main-content').style.display = 'none';
                    document.getElementById('success-modal').classList.remove('hidden');
                    
                    document.body.onclick = function() { return false; };
                    document.body.oncontextmenu = function() { return false; };
                    document.onkeydown = function() { return false; };
                }
            });
        } else {
            alert('Le texte saisi ne correspond pas exactement au texte requis. Veuillez vérifier et ressaisir.');
            textarea.focus();
        }
    }
    <?php endif; ?>
</script>

</body>
</html>