<?php
require_once 'db.php';

$data = json_decode(file_get_contents('php://input'), true);
$cart = $data ?? [];

$items_html = '';
$total = 0;

foreach($cart as $product_id => $quantity) {
    $stmt = $db->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch();
    
    if($product) {
        $subtotal = $product['price'] * $quantity;
        $total += $subtotal;
        
        $items_html .= "
            <div class='flex justify-between items-center mb-4 pb-4 border-b'>
                <div>
                    <h3 class='font-semibold'>{$product['title']}</h3>
                    <p class='text-gray-600'>Quantity: {$quantity}</p>
                </div>
                <div>\${$subtotal}</div>
            </div>";
    }
}

echo json_encode([
    'items' => $items_html,
    'total' => number_format($total, 2)
]);