<?php
// Fichier session-bridge.php - À placer sur idsma.imators.com

session_start();

header('Access-Control-Allow-Origin: https://andweare.com');
header('Access-Control-Allow-Credentials: true');
header('Content-Type: application/json');

// Paramètre de sécurité pour vérifier la validité de la demande
$token = filter_input(INPUT_GET, 'token', FILTER_SANITIZE_STRING);
$secret_key = 'K8P5nxL$2jRwVmGa7yQtHdAzC@_bYs9F3u6EX#N4ZWJTvf!e'; // Clé partagée entre les deux domaines

// Vérifier que la requête est autorisée
if (empty($token) || hash('sha256', $secret_key . date('Ymd')) !== $token) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized access']);
    exit;
}

// Récupérer les données de session à partager
$session_data = [
    'status' => 'success',
    'user_id' => $_SESSION['user_id'] ?? null,
    'username' => $_SESSION['username'] ?? null,
    'andweare_member' => $_SESSION['andweare_member'] ?? 0,
    'family_site_url' => $_SESSION['family_site_url'] ?? '',
    'family_role' => $_SESSION['family_role'] ?? '',
];

// Générer un token de session unique
if (!empty($session_data['user_id'])) {
    $session_data['auth_token'] = hash('sha256', $secret_key . $session_data['user_id'] . time());
    
    // Stocker le token dans la base de données pour vérification ultérieure
    try {
        require_once 'db.php';
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("INSERT INTO session_tokens (user_id, token, expires_at) VALUES (?, ?, DATE_ADD(NOW(), INTERVAL 1 HOUR))");
        $stmt->execute([$session_data['user_id'], $session_data['auth_token']]);
    } catch (Exception $e) {
        // Gérer l'erreur silencieusement
    }
}

echo json_encode($session_data);
?>