<?php
require_once 'db.php';

$logFile = __DIR__ . '/imators-billboard.log';

function writeLog($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

writeLog('Démarrage du serveur de gestion des panneaux Imators');

while (true) {
    try {
        $now = new DateTime();
        $offline = $now->sub(new DateInterval('PT1H'))->format('Y-m-d H:i:s');
        
        $stmt = $pdo->prepare("SELECT * FROM `imators-systems-billboard` WHERE last_seen < ?");
        $stmt->execute([$offline]);
        $offlineBillboards = $stmt->fetchAll();
        
        foreach ($offlineBillboards as $billboard) {
            writeLog("Panneau {$billboard['serial']} détecté hors ligne (dernière connexion: {$billboard['last_seen']})");
        }
        
        writeLog("Vérification terminée - " . count($offlineBillboards) . " panneaux hors ligne");
    } catch (Exception $e) {
        writeLog("ERREUR: " . $e->getMessage());
    }
    
    sleep(300);
}