<?php
session_start();

function detectVPN() {
    $vpn_indicators = [
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_REAL_IP',
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_CLIENT_IP'
    ];
    
    foreach ($vpn_indicators as $header) {
        if (isset($_SERVER[$header])) {
            return true;
        }
    }
    
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $vpn_ranges = [
        '10.0.0.0/8',
        '172.16.0.0/12',
        '192.168.0.0/16'
    ];
    
    foreach ($vpn_ranges as $range) {
        if (ip_in_range($user_ip, $range)) {
            return true;
        }
    }
    
    return false;
}

function ip_in_range($ip, $range) {
    list($subnet, $bits) = explode('/', $range);
    $ip = ip2long($ip);
    $subnet = ip2long($subnet);
    $mask = -1 << (32 - $bits);
    $subnet &= $mask;
    return ($ip & $mask) == $subnet;
}

if (isset($_POST['disable_overlay'])) {
    $_SESSION['overlay_disabled'] = true;
    header('Location: ' . $_SERVER['REQUEST_URI']);
    exit;
}

if (isset($_POST['retry_verification'])) {
    unset($_SESSION['overlay_disabled']);
    header('Location: ' . $_SERVER['REQUEST_URI']);
    exit;
}

$show_overlay = true;

if (isset($_SESSION['overlay_disabled'])) {
    $show_overlay = false;
} else {
    $vpn_detected = detectVPN();
    if (!$vpn_detected) {
        $show_overlay = true;
    }
}
?>

<div id="securityOverlay" style="position: fixed !important; top: 0 !important; left: 0 !important; width: 100vw !important; height: 100vh !important; background: rgba(0, 0, 0, 0.95) !important; backdrop-filter: blur(30px) !important; -webkit-backdrop-filter: blur(30px) !important; z-index: 999999 !important; display: flex !important; align-items: center !important; justify-content: center !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important;">
    <div style="background: #0a0a0a !important; border: 1px solid #1a1a1a !important; border-radius: 16px !important; padding: 40px !important; text-align: center !important; max-width: 450px !important; width: 90% !important; backdrop-filter: blur(20px) !important; box-shadow: 0 25px 50px rgba(0, 0, 0, 0.5) !important;">
        
        <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" style="width: 80px !important; height: 80px !important; margin: 0 auto 25px !important; display: block !important; border-radius: 8px !important;">
        
        <h1 style="font-size: 24px !important; font-weight: 500 !important; margin-bottom: 15px !important; color: #ffffff !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important; letter-spacing: -0.5px !important;">Imators Systems</h1>
        
        <p style="font-size: 15px !important; color: #a0a0a0 !important; margin-bottom: 30px !important; line-height: 1.5 !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important; font-weight: 400 !important;">Security verification in progress. Please ensure VPN and ad-blockers are disabled for optimal experience.</p>
        
        <div id="loadingSpinner" style="width: 40px !important; height: 40px !important; border: 2px solid #1a1a1a !important; border-top: 2px solid #ffffff !important; border-radius: 50% !important; animation: securitySpin 1s linear infinite !important; margin: 20px auto !important;"></div>
        
        <div id="errorMessage" style="color: #ff4444 !important; font-size: 13px !important; margin-top: 15px !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important; display: none !important; font-weight: 400 !important;"></div>
        
        <form method="post" style="display: flex !important; gap: 12px !important; justify-content: center !important; margin-top: 25px !important;">
            <button type="submit" name="retry_verification" style="padding: 12px 20px !important; border: none !important; border-radius: 8px !important; cursor: pointer !important; font-size: 14px !important; font-weight: 500 !important; background: #ffffff !important; color: #000000 !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important; transition: all 0.2s ease !important;">Retry Verification</button>
            <button type="submit" name="disable_overlay" style="padding: 12px 20px !important; border: 1px solid #2a2a2a !important; border-radius: 8px !important; cursor: pointer !important; font-size: 14px !important; font-weight: 500 !important; background: transparent !important; color: #a0a0a0 !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif !important; transition: all 0.2s ease !important;">Continue Anyway</button>
        </form>
    </div>
</div>

<style>
@keyframes securitySpin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let adBlockDetected = false;
    let vpnDetected = <?php echo detectVPN() ? 'true' : 'false'; ?>;

    function checkAdBlocker() {
        const adBlockTest = document.createElement('div');
        adBlockTest.innerHTML = '&nbsp;';
        adBlockTest.className = 'adsbox';
        adBlockTest.style.position = 'absolute';
        adBlockTest.style.left = '-9999px';
        document.body.appendChild(adBlockTest);
        
        setTimeout(() => {
            if (adBlockTest.offsetHeight === 0) {
                adBlockDetected = true;
                showError();
            }
            document.body.removeChild(adBlockTest);
        }, 100);
    }

    function showError() {
        const errorMsg = document.getElementById('errorMessage');
        const spinner = document.getElementById('loadingSpinner');
        
        if (vpnDetected || adBlockDetected) {
            errorMsg.style.display = 'block';
            errorMsg.innerHTML = 'VPN or ad-blocker detected. Please disable and retry.';
            spinner.style.display = 'none';
        }
    }

    setTimeout(() => {
        if (!vpnDetected && !adBlockDetected) {
            document.getElementById('securityOverlay').style.display = 'none';
        }
    }, 2000);

    checkAdBlocker();
    
    if (vpnDetected) {
        showError();
    }
});
</script>