<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Synthèse des Fractions</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .fraction {
            display: inline-block;
            text-align: center;
            vertical-align: middle;
        }
        .fraction .numerator {
            display: block;
            border-bottom: 1px solid #000;
            padding: 0 8px;
        }
        .fraction .denominator {
            display: block;
            padding: 0 8px;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="container mx-auto p-4 md:p-6">
        <h1 class="text-3xl md:text-4xl font-bold text-center text-gray-800 mb-6 md:mb-8">Synthèse Complète des Fractions</h1>
        
        <div class="bg-white rounded-lg shadow-lg">
            <div class="flex border-b overflow-x-auto">
                <button onclick="showTab('addition')" id="tab-addition" class="px-4 py-3 bg-blue-600 text-white font-semibold whitespace-nowrap text-sm md:text-base md:px-6">Addition</button>
                <button onclick="showTab('soustraction')" id="tab-soustraction" class="px-4 py-3 bg-gray-200 hover:bg-gray-300 whitespace-nowrap text-sm md:text-base md:px-6">Soustraction</button>
                <button onclick="showTab('multiplication')" id="tab-multiplication" class="px-4 py-3 bg-gray-200 hover:bg-gray-300 whitespace-nowrap text-sm md:text-base md:px-6">Multiplication</button>
                <button onclick="showTab('division')" id="tab-division" class="px-4 py-3 bg-gray-200 hover:bg-gray-300 whitespace-nowrap text-sm md:text-base md:px-6">Division</button>
                <button onclick="showTab('graphiques')" id="tab-graphiques" class="px-4 py-3 bg-gray-200 hover:bg-gray-300 whitespace-nowrap text-sm md:text-base md:px-6">Graphiques</button>
            </div>

            <div id="content-addition" class="p-4 md:p-8 tab-content">
                <h2 class="text-2xl md:text-3xl font-bold mb-6 text-blue-600">Addition de Fractions</h2>
                
                <div class="bg-blue-50 p-6 rounded-lg mb-6">
                    <h3 class="text-xl font-semibold mb-4">Règle :</h3>
                    <p class="text-lg">On met tout sur le même dénominateur, puis on additionne les numérateurs</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div>
                        <h3 class="text-xl font-semibold mb-4">Même dénominateur :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">3</span><span class="denominator">7</span></span>
                            <span class="mx-4">+</span>
                            <span class="fraction"><span class="numerator">2</span><span class="denominator">7</span></span>
                            <span class="mx-4">=</span>
                            <span class="fraction"><span class="numerator">5</span><span class="denominator">7</span></span>
                        </div>
                        <p class="text-gray-600">Simple : on garde le dénominateur et on additionne 3 + 2 = 5</p>
                    </div>

                    <div>
                        <h3 class="text-xl font-semibold mb-4">Dénominateurs différents :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">1</span><span class="denominator">3</span></span>
                            <span class="mx-4">+</span>
                            <span class="fraction"><span class="numerator">1</span><span class="denominator">6</span></span>
                        </div>
                        <div class="text-lg space-y-2">
                            <p><strong>Étape 1 :</strong> Trouver le dénominateur commun (6)</p>
                            <p><strong>Étape 2 :</strong> <span class="fraction"><span class="numerator">2</span><span class="denominator">6</span></span> + <span class="fraction"><span class="numerator">1</span><span class="denominator">6</span></span></p>
                            <p><strong>Résultat :</strong> <span class="fraction"><span class="numerator">3</span><span class="denominator">6</span></span> = <span class="fraction"><span class="numerator">1</span><span class="denominator">2</span></span></p>
                        </div>
                    </div>
                </div>
            </div>

            <div id="content-soustraction" class="p-4 md:p-8 tab-content hidden">
                <h2 class="text-2xl md:text-3xl font-bold mb-6 text-green-600">Soustraction de Fractions</h2>
                
                <div class="bg-green-50 p-6 rounded-lg mb-6">
                    <h3 class="text-xl font-semibold mb-4">Règle :</h3>
                    <p class="text-lg">On met tout sur le même dénominateur, puis on soustrait les numérateurs</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div>
                        <h3 class="text-xl font-semibold mb-4">Même dénominateur :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">5</span><span class="denominator">8</span></span>
                            <span class="mx-4">-</span>
                            <span class="fraction"><span class="numerator">2</span><span class="denominator">8</span></span>
                            <span class="mx-4">=</span>
                            <span class="fraction"><span class="numerator">3</span><span class="denominator">8</span></span>
                        </div>
                        <p class="text-gray-600">On garde le dénominateur et on fait 5 - 2 = 3</p>
                    </div>

                    <div>
                        <h3 class="text-xl font-semibold mb-4">Dénominateurs différents :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">3</span><span class="denominator">4</span></span>
                            <span class="mx-4">-</span>
                            <span class="fraction"><span class="numerator">1</span><span class="denominator">3</span></span>
                        </div>
                        <div class="text-lg space-y-2">
                            <p><strong>Étape 1 :</strong> Dénominateur commun (12)</p>
                            <p><strong>Étape 2 :</strong> <span class="fraction"><span class="numerator">9</span><span class="denominator">12</span></span> - <span class="fraction"><span class="numerator">4</span><span class="denominator">12</span></span></p>
                            <p><strong>Résultat :</strong> <span class="fraction"><span class="numerator">5</span><span class="denominator">12</span></span></p>
                        </div>
                    </div>
                </div>
            </div>

            <div id="content-multiplication" class="p-4 md:p-8 tab-content hidden">
                <h2 class="text-2xl md:text-3xl font-bold mb-6 text-purple-600">Multiplication de Fractions</h2>
                
                <div class="bg-purple-50 p-6 rounded-lg mb-6">
                    <h3 class="text-xl font-semibold mb-4">Règle :</h3>
                    <p class="text-lg">On multiplie numérateur par numérateur et dénominateur par dénominateur</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div>
                        <h3 class="text-xl font-semibold mb-4">Exemple simple :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">2</span><span class="denominator">3</span></span>
                            <span class="mx-4">×</span>
                            <span class="fraction"><span class="numerator">4</span><span class="denominator">5</span></span>
                            <span class="mx-4">=</span>
                            <span class="fraction"><span class="numerator">8</span><span class="denominator">15</span></span>
                        </div>
                        <p class="text-gray-600">2 × 4 = 8 et 3 × 5 = 15</p>
                    </div>

                    <div>
                        <h3 class="text-xl font-semibold mb-4">Avec simplification :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">3</span><span class="denominator">8</span></span>
                            <span class="mx-4">×</span>
                            <span class="fraction"><span class="numerator">4</span><span class="denominator">9</span></span>
                        </div>
                        <div class="text-lg space-y-2">
                            <p><strong>Avant :</strong> <span class="fraction"><span class="numerator">12</span><span class="denominator">72</span></span></p>
                            <p><strong>Après simplification :</strong> <span class="fraction"><span class="numerator">1</span><span class="denominator">6</span></span></p>
                            <p class="text-gray-600">On divise par 12</p>
                        </div>
                    </div>
                </div>
            </div>

            <div id="content-division" class="p-4 md:p-8 tab-content hidden">
                <h2 class="text-2xl md:text-3xl font-bold mb-6 text-red-600">Division de Fractions</h2>
                
                <div class="bg-red-50 p-6 rounded-lg mb-6">
                    <h3 class="text-xl font-semibold mb-4">Règle :</h3>
                    <p class="text-lg">On inverse la fraction diviseur et on multiplie</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div>
                        <h3 class="text-xl font-semibold mb-4">Méthode :</h3>
                        <div class="text-2xl mb-4">
                            <span class="fraction"><span class="numerator">7</span><span class="denominator">8</span></span>
                            <span class="mx-4">÷</span>
                            <span class="fraction"><span class="numerator">2</span><span class="denominator">3</span></span>
                        </div>
                        <div class="text-lg space-y-2">
                            <p><strong>Étape 1 :</strong> Inverser <span class="fraction"><span class="numerator">2</span><span class="denominator">3</span></span> → <span class="fraction"><span class="numerator">3</span><span class="denominator">2</span></span></p>
                            <p><strong>Étape 2 :</strong> <span class="fraction"><span class="numerator">7</span><span class="denominator">8</span></span> × <span class="fraction"><span class="numerator">3</span><span class="denominator">2</span></span></p>
                            <p><strong>Résultat :</strong> <span class="fraction"><span class="numerator">21</span><span class="denominator">16</span></span></p>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-xl font-semibold mb-4">Pourquoi ça marche ?</h3>
                        <div class="bg-gray-100 p-4 rounded">
                            <p class="mb-2">Diviser par une fraction = multiplier par son inverse</p>
                            <p class="text-sm text-gray-600">Exemple : "combien de moitiés dans 3 ?" = 3 ÷ <span class="fraction"><span class="numerator">1</span><span class="denominator">2</span></span> = 3 × 2 = 6</p>
                        </div>
                    </div>
                </div>
            </div>

            <div id="content-graphiques" class="p-4 md:p-8 tab-content hidden">
                <h2 class="text-2xl md:text-3xl font-bold mb-6 text-indigo-600">Types de Graphiques avec Données</h2>
                
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8">
                    <div class="bg-indigo-50 p-4 md:p-6 rounded-lg">
                        <h3 class="text-lg md:text-xl font-semibold mb-4">Graphique Circulaire (Camembert)</h3>
                        <div class="relative w-32 h-32 md:w-40 md:h-40 mx-auto mb-4">
                            <svg width="100%" height="100%" viewBox="0 0 160 160" class="transform -rotate-90">
                                <circle cx="80" cy="80" r="70" fill="#e5e7eb" stroke="#374151" stroke-width="2"/>
                                <circle cx="80" cy="80" r="70" fill="none" stroke="#3b82f6" stroke-width="12" 
                                        stroke-dasharray="132 308" stroke-linecap="round"/>
                                <circle cx="80" cy="80" r="70" fill="none" stroke="#ef4444" stroke-width="12" 
                                        stroke-dasharray="88 352" stroke-dashoffset="-132" stroke-linecap="round"/>
                                <circle cx="80" cy="80" r="70" fill="none" stroke="#10b981" stroke-width="12" 
                                        stroke-dasharray="88 352" stroke-dashoffset="-220" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <div class="text-sm space-y-1">
                            <div class="flex items-center justify-center"><div class="w-3 h-3 bg-blue-500 rounded mr-2"></div>Ventes: 30%</div>
                            <div class="flex items-center justify-center"><div class="w-3 h-3 bg-red-500 rounded mr-2"></div>Marketing: 20%</div>
                            <div class="flex items-center justify-center"><div class="w-3 h-3 bg-green-500 rounded mr-2"></div>R&D: 20%</div>
                            <div class="flex items-center justify-center"><div class="w-3 h-3 bg-gray-300 rounded mr-2"></div>Autres: 30%</div>
                        </div>
                    </div>

                    <div class="bg-green-50 p-4 md:p-6 rounded-lg">
                        <h3 class="text-lg md:text-xl font-semibold mb-4">Graphique en Barres</h3>
                        <div class="space-y-3">
                            <div class="flex items-center">
                                <span class="w-16 md:w-20 text-xs md:text-sm">Jan</span>
                                <div class="flex-1 h-6 bg-gray-200 rounded ml-2">
                                    <div class="w-4/5 h-full bg-blue-500 rounded"></div>
                                </div>
                                <span class="w-8 text-xs md:text-sm ml-2">80k</span>
                            </div>
                            <div class="flex items-center">
                                <span class="w-16 md:w-20 text-xs md:text-sm">Fév</span>
                                <div class="flex-1 h-6 bg-gray-200 rounded ml-2">
                                    <div class="w-3/5 h-full bg-green-500 rounded"></div>
                                </div>
                                <span class="w-8 text-xs md:text-sm ml-2">60k</span>
                            </div>
                            <div class="flex items-center">
                                <span class="w-16 md:w-20 text-xs md:text-sm">Mar</span>
                                <div class="flex-1 h-6 bg-gray-200 rounded ml-2">
                                    <div class="w-full h-full bg-purple-500 rounded"></div>
                                </div>
                                <span class="w-8 text-xs md:text-sm ml-2">100k</span>
                            </div>
                        </div>
                        <p class="text-center text-xs md:text-sm mt-4 text-gray-600">Chiffre d'affaires mensuel</p>
                    </div>

                    <div class="bg-yellow-50 p-4 md:p-6 rounded-lg">
                        <h3 class="text-lg md:text-xl font-semibold mb-4">Graphique Linéaire</h3>
                        <div class="relative h-32 md:h-40">
                            <svg width="100%" height="100%" viewBox="0 0 300 160" class="border rounded">
                                <defs>
                                    <pattern id="grid" width="30" height="16" patternUnits="userSpaceOnUse">
                                        <path d="M 30 0 L 0 0 0 16" fill="none" stroke="#e5e7eb" stroke-width="1"/>
                                    </pattern>
                                </defs>
                                <rect width="100%" height="100%" fill="url(#grid)"/>
                                <polyline fill="none" stroke="#eab308" stroke-width="3" 
                                          points="30,140 60,120 90,100 120,80 150,60 180,80 210,70 240,50 270,40"/>
                                <circle cx="30" cy="140" r="3" fill="#eab308"/>
                                <circle cx="60" cy="120" r="3" fill="#eab308"/>
                                <circle cx="90" cy="100" r="3" fill="#eab308"/>
                                <circle cx="120" cy="80" r="3" fill="#eab308"/>
                                <circle cx="150" cy="60" r="3" fill="#eab308"/>
                                <circle cx="180" cy="80" r="3" fill="#eab308"/>
                                <circle cx="210" cy="70" r="3" fill="#eab308"/>
                                <circle cx="240" cy="50" r="3" fill="#eab308"/>
                                <circle cx="270" cy="40" r="3" fill="#eab308"/>
                            </svg>
                        </div>
                        <p class="text-center text-xs md:text-sm mt-2 text-gray-600">Évolution des ventes sur 9 mois</p>
                    </div>

                    <div class="bg-purple-50 p-4 md:p-6 rounded-lg">
                        <h3 class="text-lg md:text-xl font-semibold mb-4">Graphique en Aires</h3>
                        <div class="relative h-32 md:h-40">
                            <svg width="100%" height="100%" viewBox="0 0 300 160" class="border rounded">
                                <defs>
                                    <linearGradient id="gradient1" x1="0%" y1="0%" x2="0%" y2="100%">
                                        <stop offset="0%" style="stop-color:#8b5cf6;stop-opacity:0.8" />
                                        <stop offset="100%" style="stop-color:#8b5cf6;stop-opacity:0.1" />
                                    </linearGradient>
                                </defs>
                                <polygon fill="url(#gradient1)" stroke="#8b5cf6" stroke-width="2"
                                         points="30,160 30,120 60,100 90,80 120,70 150,60 180,70 210,65 240,50 270,40 270,160"/>
                            </svg>
                        </div>
                        <p class="text-center text-xs md:text-sm mt-2 text-gray-600">Croissance cumulée des utilisateurs</p>
                    </div>
                </div>

                <div class="mt-6 md:mt-8 bg-gray-50 p-4 md:p-6 rounded-lg">
                    <h3 class="text-lg md:text-xl font-semibold mb-4">Quand utiliser chaque type :</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm md:text-base">
                        <div>
                            <p><strong>Circulaire :</strong> Répartition de budget, parts de marché, pourcentages</p>
                            <p><strong>Barres :</strong> Comparaison de valeurs, classements, évolution discrète</p>
                        </div>
                        <div>
                            <p><strong>Linéaire :</strong> Évolution dans le temps, tendances, séries temporelles</p>
                            <p><strong>Aires :</strong> Volumes cumulés, croissance progressive, empilage</p>
                        </div>
                    </div>
                </div>

                <div class="mt-6 bg-blue-50 p-4 md:p-6 rounded-lg">
                    <h3 class="text-lg md:text-xl font-semibold mb-4">Exemple concret : Analyse des ventes trimestrielles</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                        <div class="bg-white p-3 rounded">
                            <h4 class="font-semibold">Q1 2024</h4>
                            <p>Ventes: 150k€</p>
                            <p>Objectif: 120k€</p>
                            <p class="text-green-600">+25% vs objectif</p>
                        </div>
                        <div class="bg-white p-3 rounded">
                            <h4 class="font-semibold">Q2 2024</h4>
                            <p>Ventes: 180k€</p>
                            <p>Objectif: 160k€</p>
                            <p class="text-green-600">+12.5% vs objectif</p>
                        </div>
                        <div class="bg-white p-3 rounded">
                            <h4 class="font-semibold">Q3 2024</h4>
                            <p>Ventes: 220k€</p>
                            <p>Objectif: 200k€</p>
                            <p class="text-green-600">+10% vs objectif</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTab(tab) {
            document.querySelectorAll('.tab-content').forEach(content => content.classList.add('hidden'));
            document.querySelectorAll('[id^="tab-"]').forEach(button => {
                button.classList.remove('bg-blue-600', 'text-white');
                button.classList.add('bg-gray-200');
            });
            
            document.getElementById(`content-${tab}`).classList.remove('hidden');
            document.getElementById(`tab-${tab}`).classList.remove('bg-gray-200');
            document.getElementById(`tab-${tab}`).classList.add('bg-blue-600', 'text-white');
        }

        showTab('addition');
    </script>
</body>
</html>