<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave a Review - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

    @media (prefers-color-scheme: dark) {
        body {
            background-color: var(--bg-dark);
            color: var(--text-dark);
        }
        .header-border {
            border-top: 1px solid var(--text-dark);
            border-bottom: 1px solid var(--text-dark);
            background-color: rgba(18, 18, 18, 0.8);
        }
        .border-custom {
            border-color: var(--border-dark);
        }
        .bg-custom {
            background-color: var(--bg-dark);
        }
        .button-custom {
            background-color: var(--text-dark);
            color: var(--bg-dark);
        }
    }

    @media (prefers-color-scheme: light) {
        body {
            background-color: var(--bg-light);
            color: var(--text-light);
        }
        .header-border {
            border-top: 1px solid var(--text-light);
            border-bottom: 1px solid var(--text-light);
            background-color: rgba(255, 255, 255, 0.8);
        }
        .border-custom {
            border-color: var(--border-light);
        }
        .bg-custom {
            background-color: var(--bg-light);
        }
        .button-custom {
            background-color: var(--text-light);
            color: var(--bg-light);
        }
    }

    body {
        font-family: 'Cabinet Grotesk', sans-serif;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .header-border {
        backdrop-filter: blur(10px);
    }

    @keyframes fadeIn {
        from {opacity: 0;transform: translateY(10px);}
        to {opacity: 1;transform: translateY(0);}
    }

    .fade-in {
        opacity: 0;
        animation: fadeIn 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
    }

    .delay-1 {animation-delay: 0.2s;}
    .delay-2 {animation-delay: 0.4s;}
    .delay-3 {animation-delay: 0.6s;}

    .main-container {
        max-width: 800px;
        margin: 0 auto;
        padding: 0 1rem;
    }

    @media (min-width: 640px) {
        .main-container {
            padding: 0 2rem;
        }
    }

    .stars {
        display: flex;
        gap: 8px;
        justify-content: center;
    }

    .star {
        color: #ddd;
        font-size: 48px;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .star.active, .star:hover {
        color: #ffd700;
        transform: scale(1.1);
    }

    .success-message {
        background-color: #10b981;
        color: white;
        padding: 1rem;
        border-radius: 12px;
        margin-bottom: 2rem;
        text-align: center;
    }

    .error-message {
        background-color: #ef4444;
        color: white;
        padding: 1rem;
        border-radius: 12px;
        margin-bottom: 2rem;
        text-align: center;
    }
</style>

</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 fade-in sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-3xl font-light tracking-tight">
                    <a href="/" class="hover:opacity-70 transition-opacity">Izhak</a>
                </h1>
                <a href="/" class="text-sm font-light hover:opacity-70 transition-opacity">← Back to Home</a>
            </div>
        </div>
    </header>

<main class="main-container">
    <div class="max-w-2xl mx-auto">
        <div class="text-center mb-12">
            <h2 class="text-5xl font-light tracking-tight mb-6 fade-in delay-1">
                Leave a Review
            </h2>
            <p class="text-lg font-light leading-relaxed fade-in delay-2">
                Your feedback means the world to me. Share your experience working together.
            </p>
        </div>

        <?php
        require_once 'db.php';

        $message = '';
        $messageType = '';

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nom = trim($_POST['name']);
            $email = trim($_POST['email']);
            $note = (int)$_POST['rating'];
            $commentaire = trim($_POST['comment']);
            $ip = $_SERVER['REMOTE_ADDR'];
            
            if (!empty($nom) && !empty($email) && !empty($commentaire) && $note >= 1 && $note <= 5) {
                try {
                    $stmt = $pdo->prepare("INSERT INTO avis (nom, email, note, commentaire, ip_address) VALUES (?, ?, ?, ?, ?)");
                    $stmt->execute([$nom, $email, $note, $commentaire, $ip]);
                    
                    $message = 'Thank you! Your review has been submitted successfully.';
                    $messageType = 'success';
                } catch(PDOException $e) {
                    $message = 'An error occurred. Please try again later.';
                    $messageType = 'error';
                }
            } else {
                $message = 'Please fill in all fields and select a rating.';
                $messageType = 'error';
            }
        }
        ?>

        <?php if (!empty($message)): ?>
            <div class="<?php echo $messageType === 'success' ? 'success-message' : 'error-message'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-8 fade-in delay-3">
            <div>
                <label class="block text-xl font-light mb-4">Your Name *</label>
                <input type="text" name="name" required 
                       class="w-full p-4 border border-custom rounded-lg bg-custom text-lg"
                       value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
            </div>
            
            <div>
                <label class="block text-xl font-light mb-4">Email Address *</label>
                <input type="email" name="email" required 
                       class="w-full p-4 border border-custom rounded-lg bg-custom text-lg"
                       value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
            </div>
            
            <div>
                <label class="block text-xl font-light mb-4 text-center">Rating *</label>
                <div class="stars mb-6" id="rating-stars">
                    <span class="star" data-rating="1">★</span>
                    <span class="star" data-rating="2">★</span>
                    <span class="star" data-rating="3">★</span>
                    <span class="star" data-rating="4">★</span>
                    <span class="star" data-rating="5">★</span>
                </div>
                <input type="hidden" name="rating" id="selected-rating" required>
                <p class="text-center text-sm opacity-70">Click the stars to rate your experience</p>
            </div>
            
            <div>
                <label class="block text-xl font-light mb-4">Your Review *</label>
                <textarea name="comment" required rows="6" 
                          class="w-full p-4 border border-custom rounded-lg bg-custom text-lg"
                          placeholder="Share your experience working with me..."><?php echo isset($_POST['comment']) ? htmlspecialchars($_POST['comment']) : ''; ?></textarea>
            </div>
            
            <button type="submit" class="button-custom px-12 py-4 rounded-full text-lg font-light tracking-wide hover:opacity-90 transition-opacity w-full">
                Submit Review
            </button>
        </form>
    </div>
</main>

<footer class="py-12 text-center text-sm font-light mt-16">
    <p>Designed with a smile.</p>
</footer>

<script>
    let selectedRating = <?php echo isset($_POST['rating']) ? (int)$_POST['rating'] : 0; ?>;

    document.addEventListener('DOMContentLoaded', function() {
        const stars = document.querySelectorAll('#rating-stars .star');
        
        stars.forEach(star => {
            star.addEventListener('click', function() {
                selectedRating = parseInt(this.dataset.rating);
                document.getElementById('selected-rating').value = selectedRating;
                updateStarDisplay(stars, selectedRating);
            });
            
            star.addEventListener('mouseover', function() {
                const rating = parseInt(this.dataset.rating);
                updateStarDisplay(stars, rating);
            });
        });
        
        document.getElementById('rating-stars').addEventListener('mouseleave', function() {
            updateStarDisplay(stars, selectedRating);
        });

        if (selectedRating > 0) {
            updateStarDisplay(stars, selectedRating);
        }
    });

    function updateStarDisplay(stars, rating) {
        stars.forEach((star, index) => {
            if (index < rating) {
                star.classList.add('active');
            } else {
                star.classList.remove('active');
            }
        });
    }
</script>

</body>
</html>