<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Request Help with Online Problem - The Lord Court</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500&display=swap" rel="stylesheet">
    <style>
        .playfair {
            font-family: 'Playfair Display', serif;
        }
        .inter-light {
            font-family: 'Inter', sans-serif;
            font-weight: 300;
        }
        .inter-medium {
            font-family: 'Inter', sans-serif;
            font-weight: 500;
        }
    </style>
</head>
<body class="bg-white min-h-screen">
    <header class="bg-white/95 backdrop-blur-sm fixed top-0 left-0 right-0 z-50">
        <div class="max-w-4xl mx-auto px-6 py-8 text-center">
            <a href="/" class="playfair text-2xl tracking-wide text-black">THE LORD COURT</a>
        </div>
    </header>

    <main class="pt-32">
        <section class="max-w-3xl mx-auto px-6 py-20 text-center">
            <h2 class="playfair text-5xl mb-8 text-black leading-tight">Request help with an online problem</h2>
            <p class="inter-light text-lg text-gray-500 leading-relaxed max-w-2xl mx-auto">
                Specialized assistance for data theft, online impersonation, cybercrime and digital security incidents.
            </p>
        </section>

        <section class="max-w-5xl mx-auto px-6 pb-20">
            <div class="grid lg:grid-cols-2 gap-12">
                <div class="space-y-8">
                    <div class="border border-gray-200 p-8">
                        <h3 class="playfair text-2xl mb-6 text-black">Our Digital Security Services</h3>
                        <div class="space-y-3">
                            <div class="inter-light text-sm text-gray-600">Data theft investigation and recovery</div>
                            <div class="inter-light text-sm text-gray-600">Online identity usurpation cases</div>
                            <div class="inter-light text-sm text-gray-600">Cybercrime incident response</div>
                            <div class="inter-light text-sm text-gray-600">Digital forensics analysis</div>
                            <div class="inter-light text-sm text-gray-600">Social media impersonation</div>
                            <div class="inter-light text-sm text-gray-600">Financial fraud online</div>
                            <div class="inter-light text-sm text-gray-600">Ransomware and malware incidents</div>
                            <div class="inter-light text-sm text-gray-600">Privacy breach investigations</div>
                        </div>
                    </div>

                    <div class="border border-gray-200 p-8">
                        <h3 class="playfair text-2xl mb-6 text-black">Coverage Areas</h3>
                        <div class="space-y-3">
                            <div class="inter-light text-sm text-gray-600">
                                <span class="inter-medium text-black">United Kingdom:</span> Full digital crime investigation services
                            </div>
                            <div class="inter-light text-sm text-gray-600">
                                <span class="inter-medium text-black">Kingdom of Belgium:</span> Comprehensive cyber security support
                            </div>
                            <div class="inter-light text-sm text-gray-600">
                                <span class="inter-medium text-black">Cross-border cases:</span> International digital crime coordination
                            </div>
                        </div>
                    </div>

                    <div class="border border-gray-200 p-6 bg-gray-50">
                        <h4 class="playfair text-lg mb-4 text-black">Emergency Contact</h4>
                        <p class="inter-light text-xs text-gray-500 mb-3">For critical incidents requiring immediate attention:</p>
                        <div class="space-y-1">
                            <p class="inter-medium text-sm text-black">+44 (0) 20 7946 0958</p>
                            <p class="inter-medium text-sm text-black">emergency@thelordcourt.com</p>
                        </div>
                    </div>
                </div>

                <div class="space-y-6">
                    <div class="border border-gray-200 p-8">
                        <h3 class="playfair text-2xl mb-8 text-black text-center">Submit Your Case</h3>
                        <form class="space-y-6">
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">FULL NAME</label>
                                <input type="text" class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors" required>
                            </div>
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">EMAIL ADDRESS</label>
                                <input type="email" class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors" required>
                            </div>
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">PHONE NUMBER</label>
                                <input type="tel" class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors" required>
                            </div>
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">TYPE OF INCIDENT</label>
                                <select class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors" required>
                                    <option value="">Select incident type</option>
                                    <option value="data-theft">Data Theft</option>
                                    <option value="identity-theft">Identity Theft</option>
                                    <option value="financial-fraud">Financial Fraud</option>
                                    <option value="ransomware">Ransomware</option>
                                    <option value="social-media">Social Media Impersonation</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">URGENCY LEVEL</label>
                                <select class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors" required>
                                    <option value="">Select urgency</option>
                                    <option value="critical">Critical - Immediate Response</option>
                                    <option value="high">High - Within 24 hours</option>
                                    <option value="medium">Medium - Within 48 hours</option>
                                    <option value="low">Low - Within 1 week</option>
                                </select>
                            </div>
                            <div>
                                <label class="inter-medium text-xs text-gray-400 block mb-3 tracking-wide">INCIDENT DESCRIPTION</label>
                                <textarea rows="6" class="w-full border border-gray-200 focus:border-black p-4 inter-light text-sm transition-colors resize-none" placeholder="Please provide detailed information about the incident, including dates, platforms involved, and any evidence you may have..." required></textarea>
                            </div>
                            <button type="submit" class="w-full bg-black text-white p-4 playfair text-lg hover:bg-gray-800 transition-colors duration-300">
                                Submit Case Report
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="bg-gray-50 border-t border-gray-200">
            <div class="max-w-4xl mx-auto px-6 py-16">
                <div class="grid md:grid-cols-3 gap-8 text-center">
                    <div>
                        <div class="w-12 h-12 border border-gray-300 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
                        </div>
                        <h3 class="playfair text-lg mb-3 text-black">24/7 Response</h3>
                        <p class="inter-light text-xs text-gray-500 leading-relaxed">Immediate assistance for critical digital security incidents</p>
                    </div>
                    <div>
                        <div class="w-12 h-12 border border-gray-300 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <h3 class="playfair text-lg mb-3 text-black">Expert Investigation</h3>
                        <p class="inter-light text-xs text-gray-500 leading-relaxed">Professional digital forensics and cybercrime analysis</p>
                    </div>
                    <div>
                        <div class="w-12 h-12 border border-gray-300 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h3 class="playfair text-lg mb-3 text-black">International Coverage</h3>
                        <p class="inter-light text-xs text-gray-500 leading-relaxed">Cross-border digital crime investigation and support</p>
                    </div>
                </div>
            </div>
        </section>
    </main>
</body>
</html>