<!DOCTYPE html>
<html data-lt-installed="true" lang="fr">
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Imators - Refund Policy</title>
	<script>
        window.intercomSettings = {
            api_base: "https://api-iam.intercom.io",
            app_id: "iy90e1rt",
        };
    </script><script>
        (function(){var w=window;var ic=w.Intercom;if(typeof ic==="function"){ic('reattach_activator');ic('update',w.intercomSettings);}else{var d=document;var i=function(){i.c(arguments);};i.q=[];i.c=function(args){i.q.push(args);};w.Intercom=i;var l=function(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/iy90e1rt';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);};if(document.readyState==='complete'){l();}else if(w.attachEvent){w.attachEvent('onload',l);}else{w.addEventListener('load',l,false);}}})();
    </script>
	<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
	<link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet" />
	<link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" /><script src="https://cdn.jsdelivr.net/npm/alpinejs@2.2.19/dist/alpine.min.js" defer></script>
	<link href="https://fonts.googleapis.com/css2?family=Karla:wght@200&amp;display=swap" rel="stylesheet" /><meta name="description" content="Imators Refund Policy - Learn about our refund procedures and policies for all Imators products and services."><!-- Facebook Meta Tags --><meta property="og:url" content="https://imators.com/refund-policy"><meta property="og:type" content="website"><meta property="og:title" content="Imators - Refund Policy"><meta property="og:description" content="Discover our refund policy and procedures for all Imators products and services"><meta property="og:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956"><!-- Twitter Meta Tags --><meta name="twitter:card" content="summary_large_image"><meta property="twitter:domain" content="imators.com"><meta property="twitter:url" content="https://imators.com/refund-policy"><meta name="twitter:title" content="Imators - Refund Policy"><meta name="twitter:description" content="Discover our refund policy and procedures for all Imators products and services"><meta name="twitter:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
	<link href="src/header/styles.css" rel="stylesheet" /><script src="src/header/script.js" defer></script>
	<style type="text/css">@import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        #progressBar {
            position: fixed;
            top: 0;
            right: 0;
            width: 4px;
            height: 0;
            background: #4C51BF;
            transition: height 0.3s;
            z-index: 1000;
        }
        .content-section {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }
        header {
            transition: background-color 0.5s;
        }
        .menu-link {
            transition: color 0.3s ease-in-out;
        }
        .visible-header-bg {
            background-color: rgba(0, 0, 0, 0.8) !important;
        }
        .visible-header-text {
            color: #FFF !important;
        }
        .footer, .mobile-menu {
            background-color: #111827;
            color: #FFF;
        }
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        .animated-gradient {
            background: linear-gradient(45deg, #6D5BBA, #8D58BF, #9D55B8, #E15594, #E15555);
            background-size: 600% 600%;
            animation: gradientBG 16s ease infinite;
        }
        .menu-animate {
            transition: transform 0.3s ease;
        }
        .menu-animate:hover {
            transform: rotate(90deg);
        }
        .link-underline::after {
            content: '';
            display: block;
            width: 0;
            height: 2px;
            background: #FFFFFF;
            transition: width .3s;
        }
        .link-underline:hover::after {
            width: 100%;
        }
        .hover-bg:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
        }
	</style>
</head>
<body class="mt-8 bg-black text-white">
<?php include 'src/header.php'; ?>

<section class="container mx-auto py-16 px-4">
    <h1 class="text-4xl mt-4 font-bold mb-8 text-blue-200">Refund Policy</h1>

    <p class="mb-4">At Imators, we are committed to ensuring your satisfaction with our products and services. This Refund Policy outlines the terms and conditions for requesting refunds for purchases made through our websites, applications, and physical products. By making a purchase from Imators, you agree to the terms of this refund policy.</p>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">1. General Refund Policy</h2>

    <p class="mb-4">Our general refund policy applies to all purchases unless otherwise specified by a particular service or product. The following conditions apply:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Refund requests must be submitted within 10 days of the purchase date.</li>
        <li class="text-blue-500">Products or services must not have been fully utilized or consumed.</li>
        <li class="text-blue-500">A valid reason must accompany the refund request, such as product malfunction, significant discrepancy from the product description, or technical issues preventing proper use.</li>
        <li class="text-blue-500">Proof of purchase is required for all refund requests.</li>
    </ul>
    
    <p class="mb-4">It is important to note that each Imators website or application has its own specific refund policy, which is clearly stated on each platform. These policies explicitly state whether refunds are accepted for that particular service. Always review the specific conditions of each platform before making a purchase.</p>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">2. Product-Specific Policies</h2>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.1 Physical Products</h3>

    <p class="mb-4">For physical products purchased in retail locations:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Products must be returned in their original packaging with all included accessories and documentation.</li>
        <li class="text-blue-500">Products must be in resalable condition with no signs of extensive use or damage beyond what would be expected from inspection and limited testing.</li>
        <li class="text-blue-500">Original proof of purchase (receipt) is required.</li>
        <li class="text-blue-500">Shipping costs for returns are typically the responsibility of the customer unless the return is due to a defect or error on our part.</li>
    </ul>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.2 Cergies+ Warranty for Physical Products</h3>

    <p class="mb-4">Refund eligibility for physical products is significantly affected by whether you purchased the Cergies+ warranty at the time of purchase:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">With Cergies+ warranty: You benefit from extended refund conditions as specified in the warranty terms, which may include coverage for accidental damage, extended return periods, and simplified return processes.</li>
        <li class="text-blue-500">Without Cergies+ warranty: Only standard refund conditions apply, and certain types of damage or issues may not be covered for refund or replacement.</li>
        <li class="text-blue-500">Complete details of Cergies+ warranty coverage are provided at the time of purchase and vary by product type.</li>
    </ul>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.3 Digital Products and Services</h3>

    <p class="mb-4">For software applications, digital content, and online services:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Refunds may be granted if the product contains significant bugs or errors that prevent its intended functioning.</li>
        <li class="text-blue-500">Refunds may be considered if our technical support team has been unable to resolve issues within a reasonable timeframe.</li>
        <li class="text-blue-500">Refunds are generally not provided for digital products that have been substantially downloaded, accessed, or used.</li>
        <li class="text-blue-500">We strongly recommend trying any available demo or free version before purchasing to ensure compatibility with your system.</li>
    </ul>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.4 Subscription Services</h3>

    <p class="mb-4">For subscription-based services:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Cancellations requested before the renewal date will prevent future charges, but we do not provide partial refunds for unused portions of the current subscription period.</li>
        <li class="text-blue-500">Annual subscriptions may be eligible for partial refunds at our discretion if canceled within 30 days of purchase or renewal.</li>
        <li class="text-blue-500">Promotional or discounted subscriptions may have different or more restrictive refund policies as specified at the time of purchase.</li>
    </ul>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">3. App Store Purchases</h2>

    <p class="mb-4">Important: Refunds are NOT accepted for payments made through:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">In-app purchases through the Apple App Store</li>
        <li class="text-blue-500">In-app purchases through the Google Play Store</li>
        <li class="text-blue-500">Payments processed via Apple Pay</li>
        <li class="text-blue-500">Payments processed via Google Pay</li>
    </ul>

    <p class="mb-4">For these types of purchases, Apple's or Google's refund policies apply exclusively. You must contact Apple or Google directly for any refund requests related to these transactions:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">For Apple App Store purchases: <a href="https://support.apple.com/billing" class="underline">https://support.apple.com/billing</a></li>
        <li class="text-blue-500">For Google Play Store purchases: <a href="https://support.google.com/googleplay/answer/2479637" class="underline">https://support.google.com/...</a></li>
    </ul>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">4. Refund Exclusions</h2>

    <p class="mb-4">Refunds will not be provided in the following cases:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">The refund request is submitted after the 10-day refund period has expired.</li>
        <li class="text-blue-500">You have violated our Terms of Use or other agreements.</li>
        <li class="text-blue-500">The issue is due to your hardware, system configuration, or other factors outside of our control.</li>
        <li class="text-blue-500">You no longer need the product or service (change of mind).</li>
        <li class="text-blue-500">You purchased the wrong product or service (although we may consider these cases on an individual basis).</li>
        <li class="text-blue-500">The purchase was made through Apple App Store, Google Play Store, Apple Pay, or Google Pay.</li>
        <li class="text-blue-500">The product was received for free, as part of a promotion, or included as a bonus with another purchase.</li>
        <li class="text-blue-500">The service or platform specifically states that refunds are not accepted.</li>
    </ul>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">5. Refund Process</h2>

    <p class="mb-4">To request a refund for eligible purchases, please follow these steps:</p>

    <ol class="list-decimal ml-8 mb-4">
        <li class="text-blue-500 mb-2">Contact our customer support team at <a href="/support" class="underline">the support page</a> with the subject line "Refund Request".</li>
        <li class="text-blue-500 mb-2">Include your order number, purchase date, and a detailed explanation of the reason for your refund request.</li>
        <li class="text-blue-500 mb-2">If applicable, include screenshots or other evidence of the issue you're experiencing.</li>
        <li class="text-blue-500 mb-2">For physical products, include images of the product in its current condition.</li>
        <li class="text-blue-500 mb-2">Our support team will review your request and may ask for additional information if needed.</li>
        <li class="text-blue-500">You will be notified of the decision regarding your refund request within 5 business days.</li>
    </ol>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">6. Refund Processing</h2>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">6.1 Refund Method</h3>

    <p class="mb-4">Refunds will be issued using the same payment method used for the original purchase. Depending on your payment provider, it may take 5-10 business days for the refunded amount to appear in your account after we have processed the refund.</p>

    <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">6.2 Partial Refunds</h3>

    <p class="mb-4">In some cases, we may offer partial refunds if:</p>

    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Only part of an order is being returned.</li>
        <li class="text-blue-500">The product has been used beyond reasonable inspection but still qualifies for a refund under specific circumstances.</li>
        <li class="text-blue-500">The issue affects only certain features or aspects of the product but doesn't render it completely unusable.</li>
    </ul>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">7. Enterprise and Custom Solutions</h2>

    <p class="mb-4">For enterprise clients or custom development projects, refund terms will be specified in the individual contract or agreement and may differ from this general policy. These customized agreements take precedence over the standard refund policy outlined here.</p>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">8. Changes to This Policy</h2>

    <p class="mb-4">We reserve the right to modify this refund policy at any time. Changes will be effective immediately upon posting to our website. Your continued use of our services following any changes indicates your acceptance of the new terms.</p>

</section>

<div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
  <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
    <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
    Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use<a>.
    </div>
    <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
    Accept
    </button>
  </div>
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    cookieBox.classList.add('opacity-0', 'translate-y-8');
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      localStorage.setItem('cookiesAccepted', 'true');
    }, 500);
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
    } else {
      setTimeout(() => {
        cookieBox.classList.remove('opacity-0', 'translate-y-8');
      }, 2000);
    }
  }
</script>

<footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>
</body>
</html>