<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

$logout_message = 'logout=1';

try {
    if (isset($_SESSION['resident_id'])) {
        include 'db.php';
        
        $resident_id = $_SESSION['resident_id'];
        
        if (isset($conn)) {
            $stmt = $conn->prepare("UPDATE residents SET last_logout = NOW() WHERE id = ?");
            $stmt->bind_param("i", $resident_id);
            $stmt->execute();
        }
        
    } elseif (isset($_SESSION['guest_mode'])) {
        $logout_message = 'guest_logout=1';
    }

    setcookie('remember_token', '', time() - 3600, '/');
    setcookie('resident_email', '', time() - 3600, '/');

    $_SESSION = array();

    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, '/');
    }

    session_destroy();

    header('Location: login.php?' . $logout_message);
    exit();
    
} catch (Exception $e) {
    echo "Erreur: " . $e->getMessage();
    echo "<br><a href='login.php'>Retour au login</a>";
}
?>