<?php
session_start();
require('tcpdf/tcpdf.php');
require('phpqrcode/qrlib.php');

// Rcupration des donnes du formulaire
$weeks = $_POST['weeks'];
$periodType = $_POST['period_type'];
$objectives = $_POST['objectives'];
$tasks = $_POST['tasks'];

// Gnrer ID unique pour ce planning
$planningId = uniqid();

// Sauvegarder les donnes dans le JSON
$planningData = [
    'user_id' => $_SESSION['user_id'],
    'weeks' => $weeks,
    'period_type' => $periodType,
    'objectives' => $objectives,
    'tasks' => $tasks,
    'created_at' => date('Y-m-d H:i:s')
];

$plannings = json_decode(file_get_contents('data/plannings.json'), true);
$plannings[$planningId] = $planningData;
file_put_contents('data/plannings.json', json_encode($plannings));

// Gnrer QR Code
$qrUrl = "https://votre-domaine.com/daily/view.php?id=" . $planningId;
QRcode::png($qrUrl, 'qrcodes/' . $planningId . '.png');

// Crer PDF
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');
$pdf->SetCreator('Daily');
$pdf->SetAuthor('Daily System');
$pdf->SetTitle('Planning hebdomadaire');

$pdf->AddPage();

// En-tte stylis
$pdf->SetFont('helvetica', 'B', 20);
$pdf->Cell(0, 10, 'Mon Planning Daily', 0, 1, 'C');
$pdf->Ln(5);

// Pour chaque semaine
for($week = 1; $week <= $weeks; $week++) {
    $pdf->SetFont('helvetica', 'B', 16);
    $pdf->Cell(0, 10, "Semaine $week", 0, 1, 'L');
    
    // Pour chaque jour
    foreach(['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'] as $day) {
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Cell(0, 8, $day, 0, 1, 'L');
        
        // Case  cocher
        $pdf->SetFont('zapfdingbats', '', 12);
        $pdf->Cell(5, 5, '', 1, 0); // Case  cocher vide
        
        // Emojis pour l'humeur
        $pdf->Cell(10, 5, 'J', 0, 0); // Content
        $pdf->Cell(10, 5, 'K', 0, 0); // Neutre
        $pdf->Cell(10, 5, 'L', 0, 1); // Triste
        
        // Objectifs et tches
        $pdf->SetFont('helvetica', '', 10);
        $pdf->MultiCell(0, 5, "Objectifs:\n" . $objectives[strtolower($day)], 0, 'L');
        $pdf->MultiCell(0, 5, "Tches:\n" . $tasks[strtolower($day)], 0, 'L');
        
        $pdf->Ln(5);
    }
    
    $pdf->AddPage();
}

// Ajouter QR Code
$pdf->Image('qrcodes/' . $planningId . '.png', 170, 250, 30);

// Output PDF
$pdf->Output('planning.pdf', 'D');