<!DOCTYPE html>
<html data-lt-installed="true" lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script>
        window.intercomSettings = {
            api_base: "https://api-iam.intercom.io",
            app_id: "iy90e1rt",
        };
    </script>
    <script>
        (function(){var w=window;var ic=w.Intercom;if(typeof ic==="function"){ic('reattach_activator');ic('update',w.intercomSettings);}else{var d=document;var i=function(){i.c(arguments);};i.q=[];i.c=function(args){i.q.push(args);};w.Intercom=i;var l=function(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/iy90e1rt';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);};if(document.readyState==='complete'){l();}else if(w.attachEvent){w.attachEvent('onload',l);}else{w.addEventListener('load',l,false);}}})();
    </script>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.2.19/dist/alpine.min.js" defer></script>
    <link href="https://fonts.googleapis.com/css2?family=Karla:wght@200&display=swap" rel="stylesheet">
    <meta name="description" content="Imators, fondée en janvier 2024 par Izhak Aktas, est une entreprise innovante spécialisée dans le développement de technologies de pointe.">
    <meta property="og:url" content="https://imators.com/progm">
    <meta property="og:type" content="site web">
    <meta property="og:title" content="Imateurs - Progm">
    <meta property="og:description" content="Découvrez une nouvelle ère technologique en intégrant de bons produits et de bons moyens dans votre vie quotidienne avec Imators.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
    <meta name="twitter:card" content="résumé_grande_image">
    <meta property="twitter:domain" content="imators.com">
    <meta property="twitter:url" content="https://imators.com/progm">
    <meta name="twitter:title" content="Imateurs - Progm">
    <meta name="twitter:description" content="Découvrez une nouvelle ère technologique en intégrant de bons produits et de bons moyens dans votre vie quotidienne avec Imators.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: black;
            color: white;
            font-family: 'Poppins', sans-serif;
        }
        .gradient-background {
            background: linear-gradient(to bottom, #000000, #8B4513);
            min-height: 100vh;
        }
        .video-frame {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .header-spacer {
            height: 64px;
        }
        .content-wrapper {
            padding-top: 20vh;
        }
        mac {
            font-family: -apple-system, BlinkMacSystemFont, sans-serif;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col justify-between">
    <?php include 'src/header.php'; ?>
    <div class="gradient-background flex-grow flex flex-col items-center justify-center">
        <div class="content-wrapper container mx-auto px-4 py-12 text-center">
            <h1 class="text-5xl mb-6 tracking-tight text-white">Progm</h1>
            <h1 class="text-sm mb-6 text-white">Plus de <span class="text-green-200">3562 installations</span></h1>
            <p class="text-xl mb-8 font-light text-white max-w-2xl mx-auto">Un organisateur simple et moderne pour des journées plus structurées sur l'ordinateur</p>
            <div class="flex justify-center space-x-4 mb-12">
                <a href="https://cdn.imators.com/ProgmInstaller.exe" download class="bg-blue-500 text-white font-semibold py-3 px-8 rounded-full hover:bg-opacity-90 transition duration-300 ease-in-out transform hover:scale-105 inline-block">
                Télécharger pour Windows
                </a>
		<a href="https://cdn.imators.com/installerprogm.dmg" download class="bg-white text-black font-semibold py-3 px-8 rounded-full hover:bg-opacity-90 transition duration-300 ease-in-out transform hover:scale-105 inline-block">
        Télécharger pour Mac
                </a>

            </div>
            <div class="video-container w-full max-w-4xl mx-auto">
                <div class="aspect-video w-full video-frame">
                    <video class="w-full h-full object-cover" autoplay loop muted playsinline>
                        <source src="https://cdn.imators.com/Progm.mp4" type="video/mp4">
                        Votre navigateur ne supporte pas la balise vid&eacute;o.
                    </video>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Suivez-nous</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Découvrir</h5>
                <a href="/fr/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Politique de confidentialité
                </a>
                <a href="/fr/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Conditions d'utilisation
                </a>
                <a href="/fr/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Accueil
                </a>
                <a href="/fr/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                À propos de nous
                </a>
                <a href="/fr/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Nous contacter
                </a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Réalité possible</h5>
                <p class="text-sm">
                Toutes les images, les vidéos et le contenu de ce site sont la propriété d'Imators.
                </p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">
                &copy; 2025 Imators. Tous droits réservés.
            </p>
            <p class="text-xs">
            Imators est une société à responsabilité limitée (LLC). Tous nos produits, qu'ils soient technologiquement physiques ou simplement en ligne, sont soumis à nos règles, auxquelles vous pouvez accéder.
            </p>
        </div>
    </footer>
</body>
</html>