<?php
function getTopVideos($userId, $limit = 5) {
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "SELECT v.*, COUNT(vv.id) as view_count 
              FROM videos v 
              LEFT JOIN video_views vv ON v.id = vv.video_id 
              WHERE v.user_id = :user_id 
              GROUP BY v.id 
              ORDER BY view_count DESC 
              LIMIT :limit";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $userId);
    $stmt->bindParam(":limit", $limit, PDO::PARAM_INT);
    $stmt->execute();
    
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getUserProfile($userId) {
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "SELECT u.*, 
              GROUP_CONCAT(DISTINCT CONCAT(s.platform, ':', s.username)) as social_networks
              FROM users u 
              LEFT JOIN social_networks s ON u.id = s.user_id 
              WHERE u.id = :user_id 
              GROUP BY u.id";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $userId);
    $stmt->execute();
    
    return $stmt->fetch(PDO::FETCH_ASSOC);
}
