<?php
// actions/like.php
require_once '../config/db.php';
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$profile_id = intval($data['profileId']);
$user_id = $_SESSION['user_id'];

// Vérifier si déjà liké
$check_query = "SELECT id FROM likes WHERE user_id = ? AND liker_id = ?";
$check_stmt = $conn->prepare($check_query);
$check_stmt->bind_param("ii", $profile_id, $user_id);
$check_stmt->execute();
$existing_like = $check_stmt->get_result()->fetch_assoc();

if (!$existing_like) {
    // Ajouter le like
    $insert_query = "INSERT INTO likes (user_id, liker_id) VALUES (?, ?)";
    $insert_stmt = $conn->prepare($insert_query);
    $insert_stmt->bind_param("ii", $profile_id, $user_id);
    $insert_stmt->execute();
}

// Récupérer le nouveau compte
$count_query = "SELECT COUNT(*) as count FROM likes WHERE user_id = ?";
$count_stmt = $conn->prepare($count_query);
$count_stmt->bind_param("i", $profile_id);
$count_stmt->execute();
$result = $count_stmt->get_result()->fetch_assoc();

echo json_encode([
    'success' => true,
    'newCount' => $result['count']
]);
?>