<?php
require_once 'config/db.php';

// Récupération des profils depuis la base de données
$query = "SELECT users.*, 
          COUNT(DISTINCT views.id) as view_count,
          COUNT(DISTINCT likes.id) as like_count,
          COUNT(DISTINCT hits.id) as hit_count
          FROM users 
          LEFT JOIN views ON users.id = views.user_id
          LEFT JOIN likes ON users.id = likes.user_id
          LEFT JOIN hits ON users.id = hits.user_id
          GROUP BY users.id
          ORDER BY users.created_at DESC";
$result = $conn->query($query);
$profiles = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hothings - Découvrez des profils passionnants</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-lg">
        <div class="max-w-6xl mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-8">
                    <a href="/" class="flex items-center space-x-3">
                        <span class="text-2xl font-bold text-purple-600">Hothings</span>
                    </a>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="#" class="text-gray-600 hover:text-purple-600">
                        <i class="fas fa-search text-xl"></i>
                    </a>
                    <a href="#" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700">
                        Connexion
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-6xl mx-auto px-4 py-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($profiles as $profile): ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <a href="profile.php?id=<?php echo $profile['id']; ?>" class="block">
                    <div class="relative">
                        <img src="<?php echo htmlspecialchars($profile['profile_picture']); ?>" 
                             alt="Photo de profil de <?php echo htmlspecialchars($profile['username']); ?>"
                             class="w-full h-64 object-cover">
                        <?php if ($profile['is_verified']): ?>
                        <div class="absolute top-2 right-2 bg-blue-500 text-white px-2 py-1 rounded-full text-sm">
                            <i class="fas fa-check-circle"></i> Vérifié
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="p-4">
                        <div class="flex justify-between items-center mb-2">
                            <h2 class="text-xl font-semibold text-gray-800">
                                <?php echo htmlspecialchars($profile['username']); ?>
                            </h2>
                            <span class="text-gray-600"><?php echo $profile['age']; ?> ans</span>
                        </div>
                        <p class="text-gray-600 mb-4 line-clamp-2">
                            <?php echo htmlspecialchars($profile['description']); ?>
                        </p>
                        <div class="flex justify-between items-center text-sm text-gray-500">
                            <div class="flex space-x-4">
                                <span><i class="fas fa-eye"></i> <?php echo number_format($profile['view_count']); ?></span>
                                <span><i class="fas fa-heart"></i> <?php echo number_format($profile['like_count']); ?></span>
                                <span><i class="fas fa-fire"></i> <?php echo number_format($profile['hit_count']); ?></span>
                            </div>
                            <?php if ($profile['instagram_handle']): ?>
                            <a href="https://instagram.com/<?php echo htmlspecialchars($profile['instagram_handle']); ?>" 
                               target="_blank" 
                               class="text-pink-500 hover:text-pink-600">
                                <i class="fab fa-instagram text-lg"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </main>

    <footer class="bg-white mt-12 py-6">
        <div class="max-w-6xl mx-auto px-4 text-center text-gray-600">
            <p>&copy; 2025 Hothings. Tous droits réservés.</p>
        </div>
    </footer>
</body>
</html>