<?php

if(isset($_POST['facture_id'])) {
    $facture_id = $_POST['facture_id'];
    
    $sql = "SELECT * FROM courriers WHERE id = ? AND destinataire_id = ? AND type = 'facture' AND paye = 0";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $facture_id, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $facture = $result->fetch_assoc();
        $montant_facture = $facture['montant'];
        
        if($montant_facture > $solde) {
            $facture_message = "Solde insuffisant pour régler cette facture";
            $facture_success = false;
        } else {
            $conn->begin_transaction();
            
            try {
                $sql = "UPDATE comptes_bancaires SET solde = solde - ? WHERE user_id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("di", $montant_facture, $user_id);
                $stmt->execute();
                
                $sql = "UPDATE courriers SET paye = 1, date_paiement = NOW() WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $facture_id);
                $stmt->execute();
                
                $emetteur_nom = $identite['nom'] . ' ' . $identite['prenom'];
                $destinataire_nom = $facture['expediteur'];
                
                $sql = "INSERT INTO transactions (user_id, destinataire_id, montant, motif, emetteur_nom, destinataire_nom) 
                        VALUES (?, 0, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $motif = "Paiement facture : " . $facture['sujet'];
                $stmt->bind_param("idsss", $user_id, $montant_facture, $motif, $emetteur_nom, $destinataire_nom);
                $stmt->execute();
                
                $conn->commit();
                
                $solde -= $montant_facture;
                
                $facture_success = true;
                header("Location: ?onglet=courrier&courrier_id=" . $facture_id);
                exit();
            } catch (Exception $e) {
                $conn->rollback();
                $facture_message = "Une erreur est survenue lors du paiement de la facture";
                $facture_success = false;
            }
        }
    } else {
        $facture_message = "Facture introuvable ou déjà payée";
        $facture_success = false;
    }
}
?>