/*
 * Decompiled with CFR 0.152.
 */
package com.imators.discordautobot;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MinecraftAPI {
    private HttpServer server;

    public void start(int port) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.server.createContext("/status", new StatusHandler());
        this.server.createContext("/players", new PlayersHandler());
        this.server.createContext("/players/list", new PlayersListHandler());
        this.server.setExecutor(null);
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    static class StatusHandler
    implements HttpHandler {
        StatusHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String response = "{\"status\":\"online\"}";
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length());
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }

    static class PlayersHandler
    implements HttpHandler {
        PlayersHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            int online = Bukkit.getOnlinePlayers().size();
            int max = Bukkit.getMaxPlayers();
            String response = String.format("{\"online\":%d,\"max\":%d}", online, max);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length());
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }

    static class PlayersListHandler
    implements HttpHandler {
        PlayersListHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            StringBuilder players = new StringBuilder("[");
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (players.length() > 1) {
                    players.append(",");
                }
                players.append("\"").append(player.getName()).append("\"");
            }
            players.append("]");
            String response = "{\"players\":" + players.toString() + "}";
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length());
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }
}

