const { SlashCommandBuilder, EmbedBuilder, ChannelType } = require('discord.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('suggestion')
        .setDescription('Propose une suggestion')
        .addStringOption(option =>
            option.setName('suggestion')
                .setDescription('Ta suggestion')
                .setRequired(true)
        )
        .addChannelOption(option =>
            option.setName('salon')
                .setDescription('Salon où poster la suggestion')
                .addChannelTypes(ChannelType.GuildText)
                .setRequired(false)
        ),
    
    async execute(interaction) {
        const suggestion = interaction.options.getString('suggestion');
        const channel = interaction.options.getChannel('salon') || interaction.channel;
        
        const guildConfig = global.guildConfigs.get(interaction.guild.id) || {};
        const suggestionChannel = guildConfig.suggestionChannel;
        
        const targetChannel = suggestionChannel ? 
            interaction.guild.channels.cache.get(suggestionChannel) : channel;

        const embed = new EmbedBuilder()
            .setColor('#00FF00')
            .setTitle('💡 Nouvelle Suggestion')
            .setDescription(suggestion)
            .addFields(
                { name: '👤 Proposé par', value: `${interaction.user}`, inline: true },
                { name: '📅 Date', value: `<t:${Math.floor(Date.now() / 1000)}:F>`, inline: true }
            )
            .setFooter({ text: 'Peerkinton • Système de suggestions' })
            .setTimestamp();

        const message = await targetChannel.send({ embeds: [embed] });
        await message.react('👍');
        await message.react('👎');

        await interaction.reply({ 
            content: `✅ Ta suggestion a été postée dans ${targetChannel}!`, 
            ephemeral: true 
        });
    }
};